/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.util.Collections;
import java.util.Map;
import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.extensions.file.ManipulatedSnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetAutoTitleFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetRevealLineStopFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.python.PythonCode;
import org.testingisdocumenting.znai.python.PythonCodeEntry;
import org.testingisdocumenting.znai.python.PythonIncludePluginBase;
import org.testingisdocumenting.znai.python.PythonIncludeResult;

public class PythonIncludePlugin
extends PythonIncludePluginBase {
    private boolean isBodyOnly;

    @Override
    public String id() {
        return "python";
    }

    @Override
    public IncludePlugin create() {
        return new PythonIncludePlugin();
    }

    @Override
    public PythonIncludeResult process(PythonCode parsed) {
        this.isBodyOnly = this.pluginParams.getOpts().get("bodyOnly", false);
        PythonCodeEntry codeEntry = this.findEntryByName(parsed, this.entryName);
        ManipulatedSnippetContentProvider contentProvider = new ManipulatedSnippetContentProvider(this.givenFilePath, this.extractContent(codeEntry), this.pluginParams);
        this.features.add(new SnippetAutoTitleFeature(contentProvider));
        this.features.add(new SnippetHighlightFeature(this.componentsRegistry, this.pluginParams, contentProvider));
        this.features.add(new SnippetRevealLineStopFeature(this.pluginParams, contentProvider));
        Map<String, Object> props = CodeSnippetsProps.create("python", contentProvider.snippetContent());
        props.putAll(this.pluginParams.getOpts().toMap());
        this.features.updateProps(props);
        DocElement docElement = new DocElement("Snippet");
        props.forEach(docElement::addProp);
        return new PythonIncludeResult(Collections.singletonList(docElement), contentProvider.snippetContent());
    }

    private String extractContent(PythonCodeEntry codeEntry) {
        if (this.isBodyOnly) {
            return codeEntry.getBodyOnly();
        }
        return codeEntry.getContent();
    }
}

