/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.python.PythonBasedPythonParser;
import org.testingisdocumenting.znai.python.PythonCode;
import org.testingisdocumenting.znai.python.PythonCodeEntry;
import org.testingisdocumenting.znai.python.PythonIncludeResult;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public abstract class PythonIncludePluginBase
implements IncludePlugin {
    private PythonIncludeResult pythonResult;
    protected String givenFilePath;
    protected String entryName;
    protected Path fullPath;
    protected ComponentsRegistry componentsRegistry;
    protected PluginParams pluginParams;
    protected PluginFeatureList features;
    protected CodeReferencesFeature codeReferencesFeature;

    public abstract PythonIncludeResult process(PythonCode var1);

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        this.componentsRegistry = componentsRegistry;
        this.pluginParams = pluginParams;
        this.givenFilePath = pluginParams.getFreeParam();
        if (!resourcesResolver.canResolve(this.givenFilePath)) {
            throw new IllegalArgumentException("can't find file: " + this.givenFilePath);
        }
        this.codeReferencesFeature = new CodeReferencesFeature(componentsRegistry, markupPath, pluginParams);
        this.features = new PluginFeatureList(this.codeReferencesFeature);
        this.fullPath = resourcesResolver.fullPath(this.givenFilePath);
        this.entryName = pluginParams.getOpts().getRequiredString("entry");
        PythonCode pythonParseResult = PythonBasedPythonParser.INSTANCE.parse(this.fullPath);
        this.pythonResult = this.process(pythonParseResult);
        return PluginResult.docElements(this.pythonResult.getDocElements().stream());
    }

    protected PythonCodeEntry findEntryByName(PythonCode parsed, String name) {
        PythonCodeEntry entry = parsed.findEntryByName(name);
        if (entry == null) {
            throw new RuntimeException("can't find entry: " + name + " in: " + this.givenFilePath + ", available entries: " + parsed.namesStream().collect(Collectors.joining(", ")));
        }
        return entry;
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.fullPath));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.HIGH.text(this.pythonResult.getText());
    }
}

