/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python.pydoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testingisdocumenting.znai.python.PythonParam;
import org.testingisdocumenting.znai.python.pydoc.PythonDocParser;
import org.testingisdocumenting.znai.python.pydoc.PythonDocParserResult;
import org.testingisdocumenting.znai.utils.StringUtils;

public class PythonDocPandasLikeParser
implements PythonDocParser {
    private final String PARAMETERS_HEADER = "Parameters";
    private final String UNDERSCORE_PATTERN = "\\s+[-_]+";
    private final Pattern HEADER_START = Pattern.compile("\\w+\\s+[-_]+");
    private final Pattern PARAMETERS_START = Pattern.compile("Parameters\\s+[-_]+");
    private final Pattern PARAMETER_NAME_TYPE = Pattern.compile("^(\\w+)\\s*:\\s*(.*)\\s*");
    private final List<PythonParam> params = new ArrayList<PythonParam>();
    private String currentName = "";
    private String currentType;
    private List<String> currentDocLines;

    @Override
    public boolean handles(String pyDoc) {
        if (pyDoc == null) {
            return false;
        }
        return this.HEADER_START.matcher(pyDoc).find();
    }

    @Override
    public PythonDocPandasLikeParser create() {
        return new PythonDocPandasLikeParser();
    }

    @Override
    public PythonDocParserResult parse(String pyDoc) {
        String descriptionOnly = this.extractDescriptionOnly(pyDoc);
        List<PythonParam> params = this.parseParams(pyDoc);
        return new PythonDocParserResult(descriptionOnly, params);
    }

    private String extractDescriptionOnly(String pyDoc) {
        Matcher matcher = this.HEADER_START.matcher(pyDoc);
        if (!matcher.find()) {
            return pyDoc;
        }
        return pyDoc.substring(0, matcher.start()).trim();
    }

    private List<PythonParam> parseParams(String pyDoc) {
        String line;
        LineHandleResult result;
        String[] lines;
        Matcher matcher = this.PARAMETERS_START.matcher(pyDoc);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        int start = matcher.start();
        String fromParams = pyDoc.substring(start);
        String[] stringArray = lines = fromParams.split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n && (result = this.handleLine(line = stringArray[i])) != LineHandleResult.BREAK; ++i) {
        }
        this.flushParamIfRequired();
        return Collections.unmodifiableList(this.params);
    }

    private LineHandleResult handleLine(String line) {
        String trimmed = line.trim();
        if (trimmed.equals("Parameters")) {
            return LineHandleResult.CONTINUE;
        }
        if (line.startsWith("__") || line.startsWith("--")) {
            return LineHandleResult.CONTINUE;
        }
        if (trimmed.isEmpty() && this.currentName.isEmpty()) {
            return LineHandleResult.CONTINUE;
        }
        if (line.startsWith(" ") || trimmed.isEmpty()) {
            this.currentDocLines.add(line);
            return LineHandleResult.CONTINUE;
        }
        Matcher parameterNameTypeMatcher = this.PARAMETER_NAME_TYPE.matcher(trimmed);
        if (parameterNameTypeMatcher.find()) {
            this.startNewParam(parameterNameTypeMatcher.group(1), parameterNameTypeMatcher.group(2));
            return LineHandleResult.CONTINUE;
        }
        return LineHandleResult.BREAK;
    }

    private void startNewParam(String name, String type) {
        this.flushParamIfRequired();
        this.currentName = name;
        this.currentType = type;
        this.currentDocLines = new ArrayList<String>();
    }

    private void flushParamIfRequired() {
        if (this.currentName.isEmpty()) {
            return;
        }
        this.params.add(new PythonParam(this.currentName.trim(), this.currentType.trim(), StringUtils.stripIndentation(String.join((CharSequence)"\n", this.currentDocLines))));
        this.currentName = "";
    }

    private static enum LineHandleResult {
        CONTINUE,
        BREAK;

    }
}

