/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.preview;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.html.DocPageReactProps;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.server.sockets.JsonWebSocketHandler;
import org.testingisdocumenting.znai.structure.DocMeta;
import org.testingisdocumenting.znai.structure.Footer;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocItem;

public class PreviewWebSocketHandler
extends JsonWebSocketHandler {
    private static final String NAME = "preview";
    private static final String URL = "/preview";

    PreviewWebSocketHandler() {
        super(NAME, URL);
    }

    public void sendPage(DocPageReactProps pageProps) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "pageUpdate");
        payload.put("pageProps", pageProps.toMap());
        this.send(payload);
    }

    public void sendPages(Stream<DocPageReactProps> listOfPageProps) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "multiplePagesUpdate");
        payload.put("listOfPageProps", listOfPageProps.map(DocPageReactProps::toMap).collect(Collectors.toList()));
        this.send(payload);
    }

    public void sendPagesRemove(Stream<TocItem> removedTocItems) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "pagesRemove");
        payload.put("removedTocItems", removedTocItems.map(TocItem::toMap).collect(Collectors.toList()));
        this.send(payload);
    }

    public void sendToc(TableOfContents newToc) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "tocUpdate");
        payload.put("toc", newToc.toListOfMaps());
        this.send(payload);
    }

    public void sendMeta(DocMeta docMeta) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "docMetaUpdate");
        payload.put("docMeta", docMeta.toMap());
        this.send(payload);
    }

    public void sendDocReferences(DocReferences docReferences) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "docReferencesUpdate");
        payload.put("docReferences", docReferences.toMap());
        this.send(payload);
    }

    public void sendFooter(Footer footer) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "footerUpdate");
        payload.put("footer", footer.toMap());
        this.send(payload);
    }

    public void sendError(String errorMessage, String stackTrace) {
        LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
        error.put("message", errorMessage);
        error.put("stackTrace", stackTrace);
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "error");
        payload.put("error", error);
        this.send(payload);
    }

    private void send(Map<String, ?> payload) {
        this.send(URL, payload);
    }

    @Override
    public void onConnect(String uri) {
    }
}

