/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.util.Map;
import java.util.function.BiConsumer;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.buffer.Unpooled;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.handler.codec.http.HttpHeaderNames;
import znaishaded.io.netty.handler.codec.http.HttpResponseStatus;
import znaishaded.io.netty.handler.codec.http2.DefaultHttp2Headers;
import znaishaded.io.netty.handler.codec.http2.Http2Connection;
import znaishaded.io.netty.handler.codec.http2.Http2ConnectionHandler;
import znaishaded.io.netty.handler.codec.http2.Http2Error;
import znaishaded.io.netty.handler.codec.http2.Http2Exception;
import znaishaded.io.netty.handler.codec.http2.Http2Headers;
import znaishaded.io.netty.handler.codec.http2.Http2Stream;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.HttpClientOptions;
import znaishaded.io.vertx.core.http.HttpClientRequest;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.http.StreamPriority;
import znaishaded.io.vertx.core.http.StreamResetException;
import znaishaded.io.vertx.core.http.impl.Http2ConnectionBase;
import znaishaded.io.vertx.core.http.impl.Http2HeadersAdaptor;
import znaishaded.io.vertx.core.http.impl.HttpClientConnection;
import znaishaded.io.vertx.core.http.impl.HttpClientImpl;
import znaishaded.io.vertx.core.http.impl.HttpClientRequestBase;
import znaishaded.io.vertx.core.http.impl.HttpClientRequestImpl;
import znaishaded.io.vertx.core.http.impl.HttpClientRequestPushPromise;
import znaishaded.io.vertx.core.http.impl.HttpClientResponseImpl;
import znaishaded.io.vertx.core.http.impl.HttpClientStream;
import znaishaded.io.vertx.core.http.impl.HttpFrameImpl;
import znaishaded.io.vertx.core.http.impl.HttpUtils;
import znaishaded.io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import znaishaded.io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import znaishaded.io.vertx.core.http.impl.VertxHttp2Stream;
import znaishaded.io.vertx.core.http.impl.pool.ConnectionListener;
import znaishaded.io.vertx.core.impl.ContextInternal;
import znaishaded.io.vertx.core.net.NetSocket;
import znaishaded.io.vertx.core.net.impl.ConnectionBase;
import znaishaded.io.vertx.core.spi.metrics.HttpClientMetrics;

class Http2ClientConnection
extends Http2ConnectionBase
implements HttpClientConnection {
    private final ConnectionListener<HttpClientConnection> listener;
    private final HttpClientImpl client;
    private final HttpClientMetrics metrics;
    private final Object queueMetric;
    private long expirationTimestamp;

    Http2ClientConnection(ConnectionListener<HttpClientConnection> listener, Object queueMetric, HttpClientImpl client, ContextInternal context, VertxHttp2ConnectionHandler connHandler, HttpClientMetrics metrics) {
        super(context, connHandler);
        this.metrics = metrics;
        this.queueMetric = queueMetric;
        this.client = client;
        this.listener = listener;
    }

    @Override
    synchronized boolean onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        boolean goneAway = super.onGoAwaySent(lastStreamId, errorCode, debugData);
        if (goneAway) {
            this.listener.onEvict();
        }
        return goneAway;
    }

    @Override
    synchronized boolean onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        boolean goneAway = super.onGoAwayReceived(lastStreamId, errorCode, debugData);
        if (goneAway) {
            this.listener.onEvict();
        }
        return goneAway;
    }

    @Override
    protected void concurrencyChanged(long concurrency) {
        int limit = this.client.getOptions().getHttp2MultiplexingLimit();
        if (limit > 0) {
            concurrency = Math.min(concurrency, (long)limit);
        }
        this.listener.onConcurrencyChange(concurrency);
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.metrics;
    }

    @Override
    void onStreamClosed(Http2Stream nettyStream) {
        super.onStreamClosed(nettyStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeStream(Object metric, Handler<AsyncResult<HttpClientStream>> completionHandler) {
        Future<Object> fut;
        Http2ClientConnection http2ClientConnection = this;
        synchronized (http2ClientConnection) {
            try {
                Http2ClientStream stream = this.createStream(this.handler.connection().stream(1));
                stream.metric = metric;
                fut = Future.succeededFuture(stream);
            }
            catch (Exception e) {
                fut = Future.failedFuture(e);
            }
        }
        completionHandler.handle(fut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStream(Handler<AsyncResult<HttpClientStream>> completionHandler) {
        Future<Object> fut;
        Http2ClientConnection http2ClientConnection = this;
        synchronized (http2ClientConnection) {
            Http2Connection conn = this.handler.connection();
            try {
                int id = conn.local().lastStreamCreated() == 0 ? 1 : conn.local().lastStreamCreated() + 2;
                Http2ClientStream stream = this.createStream(conn.local().createStream(id, false));
                fut = Future.succeededFuture(stream);
            }
            catch (Exception e) {
                fut = Future.failedFuture(e);
            }
        }
        completionHandler.handle(fut);
    }

    private Http2ClientStream createStream(Http2Stream stream) {
        boolean writable = this.handler.encoder().flowController().isWritable(stream);
        Http2ClientStream clientStream = new Http2ClientStream(this, stream, writable);
        this.streams.put(clientStream.stream.id(), clientStream);
        return clientStream;
    }

    private void recycle() {
        int timeout = this.client.getOptions().getHttp2KeepAliveTimeout();
        this.expirationTimestamp = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : 0L;
        this.listener.onRecycle();
    }

    @Override
    public boolean isValid() {
        return this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp;
    }

    @Override
    public synchronized void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        Http2ClientStream stream = (Http2ClientStream)this.streams.get(streamId);
        if (stream != null) {
            StreamPriority streamPriority = new StreamPriority().setDependency(streamDependency).setWeight(weight).setExclusive(exclusive);
            this.context.executeFromIO(v -> stream.handleHeaders(headers, streamPriority, endOfStream));
        }
    }

    @Override
    public synchronized void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        Http2ClientStream stream = (Http2ClientStream)this.streams.get(streamId);
        if (stream != null) {
            this.context.executeFromIO(v -> stream.handleHeaders(headers, null, endOfStream));
        }
    }

    @Override
    public synchronized void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        Handler<HttpClientRequest> pushHandler;
        Http2ClientStream stream = (Http2ClientStream)this.streams.get(streamId);
        if (stream != null && (pushHandler = stream.pushHandler()) != null) {
            this.context.executeFromIO(v -> {
                int port;
                String host;
                String rawMethod = headers.method().toString();
                HttpMethod method = HttpUtils.toVertxMethod(rawMethod);
                String uri = headers.path().toString();
                String authority = headers.authority() != null ? headers.authority().toString() : null;
                Http2HeadersAdaptor headersMap = new Http2HeadersAdaptor(headers);
                Http2Stream promisedStream = this.handler.connection().stream(promisedStreamId);
                int pos = authority.indexOf(58);
                if (pos == -1) {
                    host = authority;
                    port = 80;
                } else {
                    host = authority.substring(0, pos);
                    port = Integer.parseInt(authority.substring(pos + 1));
                }
                HttpClientRequestPushPromise pushReq = new HttpClientRequestPushPromise(this, promisedStream, this.client, this.isSsl(), method, rawMethod, uri, host, port, headersMap);
                if (this.metrics != null) {
                    pushReq.getStream().metric = this.metrics.responsePushed(this.queueMetric, this.metric(), this.localAddress(), this.remoteAddress(), pushReq);
                }
                this.streams.put(promisedStreamId, pushReq.getStream());
                pushHandler.handle(pushReq);
            });
            return;
        }
        this.handler.writeReset(promisedStreamId, Http2Error.CANCEL.code());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleIdle() {
        Http2ClientConnection http2ClientConnection = this;
        synchronized (http2ClientConnection) {
            if (this.streams.isEmpty()) {
                return;
            }
        }
        super.handleIdle();
    }

    public static VertxHttp2ConnectionHandler<Http2ClientConnection> createHttp2ConnectionHandler(HttpClientImpl client, Object queueMetric, ConnectionListener<HttpClientConnection> listener, ContextInternal context, Object socketMetric, BiConsumer<Http2ClientConnection, Long> c) {
        long http2MaxConcurrency = client.getOptions().getHttp2MultiplexingLimit() <= 0 ? Long.MAX_VALUE : (long)client.getOptions().getHttp2MultiplexingLimit();
        HttpClientOptions options = client.getOptions();
        HttpClientMetrics metrics = client.metrics();
        Http2ConnectionHandler handler = ((VertxHttp2ConnectionHandlerBuilder)new VertxHttp2ConnectionHandlerBuilder().server(false)).useCompression(client.getOptions().isTryUseCompression()).initialSettings(client.getOptions().getInitialSettings()).connectionFactory(connHandler -> new Http2ClientConnection(listener, queueMetric, client, context, (VertxHttp2ConnectionHandler)connHandler, metrics)).logEnabled(options.getLogActivity()).build();
        ((VertxHttp2ConnectionHandler)handler).addHandler(conn -> {
            if (options.getHttp2ConnectionWindowSize() > 0) {
                conn.setWindowSize(options.getHttp2ConnectionWindowSize());
            }
            if (metrics != null) {
                Object m3 = socketMetric;
                if (m3 == null) {
                    m3 = metrics.connected(conn.remoteAddress(), conn.remoteName());
                    metrics.endpointConnected(queueMetric, m3);
                }
                conn.metric(m3);
            }
            long concurrency = conn.remoteSettings().getMaxConcurrentStreams();
            if (http2MaxConcurrency > 0L) {
                concurrency = Math.min(concurrency, http2MaxConcurrency);
            }
            c.accept((Http2ClientConnection)conn, concurrency);
        });
        ((VertxHttp2ConnectionHandler)handler).removeHandler(conn -> {
            if (metrics != null) {
                metrics.endpointDisconnected(queueMetric, conn.metric());
            }
            listener.onEvict();
        });
        return handler;
    }

    static class Http2ClientStream
    extends VertxHttp2Stream<Http2ClientConnection>
    implements HttpClientStream {
        private HttpClientRequestBase request;
        private HttpClientResponseImpl response;
        private Handler<Void> continueHandler;
        private boolean requestEnded;
        private boolean responseEnded;
        private Object metric;

        Http2ClientStream(Http2ClientConnection conn, Http2Stream stream, boolean writable) {
            super(conn, stream, writable);
        }

        Http2ClientStream(Http2ClientConnection conn, HttpClientRequestPushPromise request, Http2Stream stream, boolean writable) {
            super(conn, stream, writable);
            this.request = request;
        }

        @Override
        public StreamPriority priority() {
            return super.priority();
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
            super.updatePriority(streamPriority);
        }

        @Override
        public HttpVersion version() {
            return HttpVersion.HTTP_2;
        }

        @Override
        public int id() {
            return super.id();
        }

        @Override
        public Object metric() {
            return this.metric;
        }

        @Override
        void handleEnd(MultiMap trailers) {
            if (((Http2ClientConnection)this.conn).metrics != null) {
                ((Http2ClientConnection)this.conn).metrics.responseEnd(this.metric, this.response);
            }
            this.responseEnded = true;
            if (trailers == null) {
                trailers = MultiMap.caseInsensitiveMultiMap();
            }
            this.response.handleEnd(trailers);
        }

        @Override
        void handleData(Buffer buf) {
            this.response.handleChunk(buf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleReset(long errorCode) {
            Http2ClientConnection http2ClientConnection = (Http2ClientConnection)this.conn;
            synchronized (http2ClientConnection) {
                if (this.responseEnded) {
                    return;
                }
                this.responseEnded = true;
                if (((Http2ClientConnection)this.conn).metrics != null) {
                    ((Http2ClientConnection)this.conn).metrics.requestReset(this.metric);
                }
            }
            this.handleException(new StreamResetException(errorCode));
        }

        @Override
        void handleClose() {
            super.handleClose();
            if (this.request == null || this.request instanceof HttpClientRequestImpl) {
                ((Http2ClientConnection)this.conn).recycle();
            }
            if (!this.responseEnded) {
                this.responseEnded = true;
                if (((Http2ClientConnection)this.conn).metrics != null) {
                    ((Http2ClientConnection)this.conn).metrics.requestReset(this.metric);
                }
                this.handleException(ConnectionBase.CLOSED_EXCEPTION);
            }
        }

        @Override
        void handleInterestedOpsChanged() {
            if (this.request instanceof HttpClientRequestImpl && !this.isNotWritable() && !this.isNotWritable()) {
                ((HttpClientRequestImpl)this.request).handleDrained();
            }
        }

        @Override
        void handleCustomFrame(int type, int flags, Buffer buff) {
            this.response.handleUnknownFrame(new HttpFrameImpl(type, flags, buff));
        }

        @Override
        void handlePriorityChange(StreamPriority streamPriority) {
            if (streamPriority != null && !streamPriority.equals(this.priority())) {
                this.priority(streamPriority);
                this.response.handlePriorityChange(streamPriority);
            }
        }

        void handleHeaders(Http2Headers headers, StreamPriority streamPriority, boolean end) {
            if (streamPriority != null) {
                this.priority(streamPriority);
            }
            if (this.response == null) {
                String statusMessage;
                int status;
                try {
                    status = Integer.parseInt(headers.status().toString());
                    statusMessage = HttpResponseStatus.valueOf(status).reasonPhrase();
                }
                catch (Exception e) {
                    this.handleException(e);
                    this.writeReset(1L);
                    return;
                }
                if (status == 100) {
                    if (this.continueHandler != null) {
                        this.continueHandler.handle(null);
                    }
                    return;
                }
                headers.remove(":status");
                this.response = new HttpClientResponseImpl(this.request, HttpVersion.HTTP_2, this, status, statusMessage, new Http2HeadersAdaptor(headers));
                if (((Http2ClientConnection)this.conn).metrics != null) {
                    ((Http2ClientConnection)this.conn).metrics.responseBegin(this.metric, this.response);
                }
                this.request.handleResponse(this.response);
                if (end) {
                    this.onEnd();
                }
            } else if (end) {
                this.onEnd(new Http2HeadersAdaptor(headers));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleException(Throwable exception) {
            HttpClientResponseImpl resp;
            HttpClientRequestBase req;
            Http2ClientConnection http2ClientConnection = (Http2ClientConnection)this.conn;
            synchronized (http2ClientConnection) {
                req = !this.requestEnded || this.response == null || this.response.statusCode() == 100 ? this.request : null;
                resp = this.response;
            }
            if (req != null) {
                req.handleException(exception);
            }
            if (resp != null) {
                resp.handleException(exception);
            }
        }

        Handler<HttpClientRequest> pushHandler() {
            return ((HttpClientRequestImpl)this.request).pushHandler();
        }

        @Override
        public void writeHead(HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked, ByteBuf content, boolean end, StreamPriority priority, Handler<Void> contHandler, Handler<AsyncResult<Void>> handler) {
            DefaultHttp2Headers h2 = new DefaultHttp2Headers();
            h2.method(method != HttpMethod.OTHER ? method.name() : rawMethod);
            if (method == HttpMethod.CONNECT) {
                if (hostHeader == null) {
                    throw new IllegalArgumentException("Missing :authority / host header");
                }
                h2.authority(hostHeader);
            } else {
                h2.path(uri);
                h2.scheme(((Http2ClientConnection)this.conn).isSsl() ? "https" : "http");
                if (hostHeader != null) {
                    h2.authority(hostHeader);
                }
            }
            if (headers != null && headers.size() > 0) {
                for (Map.Entry header : headers) {
                    h2.add(Http2HeadersAdaptor.toLowerCase((CharSequence)header.getKey()), header.getValue());
                }
            }
            if (((Http2ClientConnection)this.conn).client.getOptions().isTryUseCompression() && h2.get(HttpHeaderNames.ACCEPT_ENCODING) == null) {
                h2.set(HttpHeaderNames.ACCEPT_ENCODING, HttpHeaders.DEFLATE_GZIP);
            }
            this.continueHandler = contHandler;
            if (((Http2ClientConnection)this.conn).metrics != null) {
                this.metric = ((Http2ClientConnection)this.conn).metrics.requestBegin(((Http2ClientConnection)this.conn).queueMetric, ((Http2ClientConnection)this.conn).metric(), ((Http2ClientConnection)this.conn).localAddress(), ((Http2ClientConnection)this.conn).remoteAddress(), this.request);
            }
            this.priority(priority);
            if (content != null) {
                this.writeHeaders(h2, false, null);
                this.writeBuffer(content, end, handler);
            } else {
                this.writeHeaders(h2, end, handler);
            }
        }

        @Override
        public void writeBuffer(ByteBuf buf, boolean end, Handler<AsyncResult<Void>> handler) {
            if (buf == null && end) {
                buf = Unpooled.EMPTY_BUFFER;
            }
            if (buf != null) {
                this.writeData(buf, end, handler);
            }
            if (end) {
                this.handlerContext.flush();
            }
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            super.writeFrame(type, flags, payload);
        }

        @Override
        public ContextInternal getContext() {
            return this.context;
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
        }

        @Override
        public boolean isNotWritable() {
            return super.isNotWritable();
        }

        @Override
        public void beginRequest(HttpClientRequestImpl req) {
            this.request = req;
        }

        @Override
        public void endRequest() {
            if (((Http2ClientConnection)this.conn).metrics != null) {
                ((Http2ClientConnection)this.conn).metrics.requestEnd(this.metric);
            }
            this.requestEnded = true;
        }

        @Override
        public void reset(Throwable cause) {
            long code;
            long l = code = cause instanceof StreamResetException ? ((StreamResetException)cause).getCode() : 0L;
            if (this.request == null) {
                this.writeReset(code);
            } else if (!this.requestEnded || !this.responseEnded) {
                this.handleException(cause);
                this.requestEnded = true;
                this.responseEnded = true;
                this.writeReset(code);
                if (((Http2ClientConnection)this.conn).metrics != null) {
                    ((Http2ClientConnection)this.conn).metrics.requestReset(this.metric);
                }
            }
        }

        @Override
        public HttpClientConnection connection() {
            return (HttpClientConnection)((Object)this.conn);
        }

        @Override
        public NetSocket createNetSocket() {
            return ((Http2ClientConnection)this.conn).toNetSocket(this);
        }
    }
}

