/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class InstructionRepeat
implements Instruction {
    private final InstructionList repeatList = new InstructionList();
    private final Instruction parent;
    private final LinkRendering nextLinkRenderer;
    private final Swimlane swimlane;
    private Swimlane swimlaneOut;
    private BoxStyle boxStyle;
    private boolean killed = false;
    private final BoxStyle boxStyleIn;
    private Display backward = Display.NULL;
    private List<PositionedNote> backwardNotes = new ArrayList<PositionedNote>();
    private Display test = Display.NULL;
    private Display yes = Display.NULL;
    private Display out = Display.NULL;
    private final Display startLabel;
    private boolean testCalled = false;
    private LinkRendering endRepeatLinkRendering = LinkRendering.none();
    private LinkRendering backRepeatLinkRendering = LinkRendering.none();
    private final Colors colors;

    @Override
    public boolean containsBreak() {
        return this.repeatList.containsBreak();
    }

    public InstructionRepeat(Swimlane swimlane, Instruction parent, LinkRendering nextLinkRenderer, HColor color, Display startLabel, BoxStyle boxStyleIn, Colors colors) {
        this.boxStyleIn = boxStyleIn;
        this.startLabel = startLabel;
        this.parent = parent;
        this.swimlane = swimlane;
        this.nextLinkRenderer = nextLinkRenderer;
        if (nextLinkRenderer == null) {
            throw new IllegalArgumentException();
        }
        this.colors = colors;
    }

    private boolean isLastOfTheParent() {
        if (this.parent instanceof InstructionList) {
            return ((InstructionList)this.parent).getLast() == this;
        }
        return false;
    }

    public void setBackward(Display label, Swimlane swimlaneOut, BoxStyle boxStyle) {
        this.backward = label;
        this.swimlaneOut = swimlaneOut;
        this.boxStyle = boxStyle;
    }

    @Override
    public void add(Instruction ins) {
        this.repeatList.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile back = this.getBackward(factory);
        Ftile decorateOut = factory.decorateOut(this.repeatList.createFtile(factory), this.endRepeatLinkRendering);
        Ftile result = factory.repeat(this.boxStyleIn, this.swimlane, this.swimlaneOut, this.startLabel, decorateOut, this.test, this.yes, this.out, this.colors, this.backRepeatLinkRendering, back, this.isLastOfTheParent());
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    private Ftile getBackward(FtileFactory factory) {
        if (Display.isNull(this.backward)) {
            return null;
        }
        Ftile result = factory.activity(this.backward, this.swimlane, this.boxStyle, Colors.empty());
        if (this.backwardNotes.size() > 0) {
            result = factory.addNote(result, this.swimlane, this.backwardNotes);
        }
        return result;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void setTest(Display test2, Display yes, Display out, LinkRendering endRepeatLinkRendering, LinkRendering backRepeatLinkRendering, Swimlane swimlaneOut) {
        this.swimlaneOut = swimlaneOut;
        this.test = test2;
        this.yes = yes;
        this.out = out;
        if (test2 == null) {
            throw new IllegalArgumentException();
        }
        if (yes == null) {
            throw new IllegalArgumentException();
        }
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.endRepeatLinkRendering = endRepeatLinkRendering;
        this.backRepeatLinkRendering = backRepeatLinkRendering;
        this.testCalled = true;
    }

    @Override
    public final boolean kill() {
        if (this.testCalled) {
            this.killed = true;
            return true;
        }
        return this.repeatList.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.nextLinkRenderer;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        if (Display.isNull(this.backward)) {
            return this.repeatList.addNote(note, position, type, colors, swimlaneNote);
        }
        this.backwardNotes.add(new PositionedNote(note, position, type, colors, swimlaneNote));
        return true;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeatList.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.parent.getSwimlaneOut();
    }
}

