/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;

public class CommandNamespace2
extends SingleLineCommand2<ClassDiagram> {
    public CommandNamespace2() {
        super(CommandNamespace2.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNamespace2.class.getName(), RegexLeaf.start(), new RegexLeaf("namespace"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("[%g]"), new RegexLeaf("DISPLAY", "([^%g]+)"), new RegexLeaf("[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([\\p{L}0-9_][-\\p{L}0-9_.:\\\\]*)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, LineLocation location, RegexResult arg) {
        String color;
        String urlString;
        String idShort = arg.get("NAME", 0);
        Ident ident = diagram.buildLeafIdent(idShort);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        IGroup currentPackage = diagram.getCurrentGroup();
        String disp = arg.getLazzy("DISPLAY", 0);
        Display display = Display.getWithNewlines(disp);
        diagram.gotoGroup(ident, code, display, GroupType.PACKAGE, currentPackage, NamespaceStrategy.MULTIPLE);
        IGroup p = diagram.getCurrentGroup();
        String stereotype = arg.get("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(new Stereotype(stereotype));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        if ((color = arg.get("COLOR", 0)) != null) {
            p.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(color));
        }
        return CommandExecutionResult.ok();
    }
}

