/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.ErrorUmlType;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.command.PSystemAbstractFactory;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.error.PSystemErrorUtils;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class PSystemSingleLineFactory
extends PSystemAbstractFactory {
    protected abstract AbstractPSystem executeLine(String var1);

    protected PSystemSingleLineFactory() {
        super(DiagramType.UML);
    }

    @Override
    public final Diagram createSystem(UmlSource source) {
        if (source.getTotalLineCount() != 3) {
            return null;
        }
        IteratorCounter2 it = source.iterator2();
        if (source.isEmpty()) {
            LineLocation location = ((StringLocated)it.next()).getLocation();
            return this.buildEmptyError(source, location, it.getTrace());
        }
        StringLocated startLine = (StringLocated)it.next();
        if (!StartUtils.isArobaseStartDiagram(startLine.getString())) {
            throw new UnsupportedOperationException();
        }
        if (!it.hasNext()) {
            return this.buildEmptyError(source, startLine.getLocation(), it.getTrace());
        }
        StringLocated s2 = (StringLocated)it.next();
        if (StartUtils.isArobaseEndDiagram(s2.getString())) {
            return this.buildEmptyError(source, s2.getLocation(), it.getTrace());
        }
        AbstractPSystem sys = this.executeLine(s2.getString());
        if (sys == null) {
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", s2.getLocation());
            return PSystemErrorUtils.buildV2(source, err, null, it.getTrace());
        }
        sys.setSource(source);
        return sys;
    }
}

