/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.ErrorUmlType;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.CommandHideShowByGender;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.CommandHideShowByVisibility;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandAffineTransform;
import znaishaded.net.sourceforge.plantuml.command.CommandAffineTransformMultiline;
import znaishaded.net.sourceforge.plantuml.command.CommandCaption;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandDecoratorMultine;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandFactorySprite;
import znaishaded.net.sourceforge.plantuml.command.CommandFooter;
import znaishaded.net.sourceforge.plantuml.command.CommandHeader;
import znaishaded.net.sourceforge.plantuml.command.CommandHideUnlinked;
import znaishaded.net.sourceforge.plantuml.command.CommandMainframe;
import znaishaded.net.sourceforge.plantuml.command.CommandMinwidth;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilinesCaption;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilinesFooter;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilinesHeader;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilinesLegend;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilinesTitle;
import znaishaded.net.sourceforge.plantuml.command.CommandNope;
import znaishaded.net.sourceforge.plantuml.command.CommandPragma;
import znaishaded.net.sourceforge.plantuml.command.CommandRotate;
import znaishaded.net.sourceforge.plantuml.command.CommandScale;
import znaishaded.net.sourceforge.plantuml.command.CommandScaleMaxHeight;
import znaishaded.net.sourceforge.plantuml.command.CommandScaleMaxWidth;
import znaishaded.net.sourceforge.plantuml.command.CommandScaleMaxWidthAndHeight;
import znaishaded.net.sourceforge.plantuml.command.CommandScaleWidthAndHeight;
import znaishaded.net.sourceforge.plantuml.command.CommandScaleWidthOrHeight;
import znaishaded.net.sourceforge.plantuml.command.CommandSkinParam;
import znaishaded.net.sourceforge.plantuml.command.CommandSkinParamMultilines;
import znaishaded.net.sourceforge.plantuml.command.CommandSpriteFile;
import znaishaded.net.sourceforge.plantuml.command.CommandTitle;
import znaishaded.net.sourceforge.plantuml.command.PSystemAbstractFactory;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.error.PSystemError;
import znaishaded.net.sourceforge.plantuml.error.PSystemErrorUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.command.CommandSkin;
import znaishaded.net.sourceforge.plantuml.statediagram.command.CommandHideEmptyDescription;
import znaishaded.net.sourceforge.plantuml.style.CommandStyleImport;
import znaishaded.net.sourceforge.plantuml.style.CommandStyleMultilinesCSS;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class UmlDiagramFactory
extends PSystemAbstractFactory {
    private List<Command> cmds;

    protected UmlDiagramFactory() {
        this(DiagramType.UML);
    }

    protected UmlDiagramFactory(DiagramType type) {
        super(type);
    }

    @Override
    public final Diagram createSystem(UmlSource source) {
        IteratorCounter2 it = source.iterator2();
        StringLocated startLine = (StringLocated)it.next();
        if (!StartUtils.isArobaseStartDiagram(startLine.getString())) {
            throw new UnsupportedOperationException();
        }
        if (source.isEmpty()) {
            if (it.hasNext()) {
                it.next();
            }
            return this.buildEmptyError(source, startLine.getLocation(), it.getTrace());
        }
        AbstractPSystem sys = this.createEmptyDiagram();
        while (it.hasNext()) {
            if (StartUtils.isArobaseEndDiagram(it.peek().getString())) {
                if (sys == null) {
                    return null;
                }
                String err = sys.checkFinalError();
                if (err != null) {
                    LineLocation location = ((StringLocated)it.next()).getLocation();
                    return this.buildExecutionError(source, err, location, it.getTrace());
                }
                if (source.getTotalLineCount() == 2) {
                    LineLocation location = ((StringLocated)it.next()).getLocation();
                    return this.buildEmptyError(source, location, it.getTrace());
                }
                sys.makeDiagramReady();
                if (!sys.isOk()) {
                    return null;
                }
                sys.setSource(source);
                return sys;
            }
            if (!((sys = this.executeFewLines(sys, source, it)) instanceof PSystemError)) continue;
            return sys;
        }
        sys.setSource(source);
        return sys;
    }

    private AbstractPSystem executeFewLines(AbstractPSystem sys, UmlSource source, IteratorCounter2 it) {
        Step step = this.getCandidate(it);
        if (step == null) {
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", it.peek().getLocation());
            it.next();
            return PSystemErrorUtils.buildV2(source, err, null, it.getTrace());
        }
        CommandExecutionResult result = sys.executeCommand(step.command, step.blocLines);
        if (!result.isOk()) {
            ErrorUml err = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, result.getError(), step.blocLines.getFirst().getLocation());
            sys = PSystemErrorUtils.buildV2(source, err, result.getDebugLines(), it.getTrace());
        }
        if (result.getNewDiagram() != null) {
            sys = result.getNewDiagram();
        }
        return sys;
    }

    private Step getCandidate(IteratorCounter2 it) {
        BlocLines single = BlocLines.single(it.peek());
        if (this.cmds == null) {
            this.cmds = this.createCommands();
        }
        for (Command cmd : this.cmds) {
            IteratorCounter2 cloned;
            BlocLines lines;
            CommandControl result = cmd.isValid(single);
            if (result == CommandControl.OK) {
                it.next();
                return new Step(cmd, single);
            }
            if (result != CommandControl.OK_PARTIAL || (lines = this.isMultilineCommandOk(cloned = it.cloneMe(), cmd)) == null) continue;
            it.copyStateFrom(cloned);
            assert (lines != null);
            return new Step(cmd, lines);
        }
        return null;
    }

    private BlocLines isMultilineCommandOk(IteratorCounter2 it, Command cmd) {
        BlocLines lines = new BlocLines();
        int nb = 0;
        while (it.hasNext()) {
            CommandControl result = cmd.isValid(lines = this.addOneSingleLineManageEmbedded2(it, lines));
            if (result == CommandControl.NOT_OK) {
                return null;
            }
            if (result == CommandControl.OK) {
                return lines;
            }
            if (!(cmd instanceof CommandDecoratorMultine) || ++nb <= ((CommandDecoratorMultine)cmd).getNbMaxLines()) continue;
            return null;
        }
        return null;
    }

    private BlocLines addOneSingleLineManageEmbedded2(IteratorCounter2 it, BlocLines lines) {
        StringLocated linetoBeAdded = (StringLocated)it.next();
        lines = lines.add(linetoBeAdded);
        if (linetoBeAdded.getTrimmed().getString().equals("{{")) {
            while (it.hasNext()) {
                StringLocated s2 = (StringLocated)it.next();
                lines = lines.add(s2);
                if (!s2.getTrimmed().getString().equals("}}")) continue;
                return lines;
            }
        }
        return lines;
    }

    protected abstract List<Command> createCommands();

    public abstract AbstractPSystem createEmptyDiagram();

    protected final void addCommonCommands1(List<Command> cmds) {
        this.addTitleCommands(cmds);
        this.addCommonCommands2(cmds);
        this.addCommonHides(cmds);
    }

    protected final void addCommonCommands2(List<Command> cmds) {
        cmds.add(new CommandNope());
        cmds.add(new CommandPragma());
        cmds.add(new CommandSkinParam());
        cmds.add(new CommandSkinParamMultilines());
        cmds.add(new CommandSkin());
        cmds.add(new CommandMinwidth());
        cmds.add(new CommandRotate());
        cmds.add(new CommandScale());
        cmds.add(new CommandScaleWidthAndHeight());
        cmds.add(new CommandScaleWidthOrHeight());
        cmds.add(new CommandScaleMaxWidth());
        cmds.add(new CommandScaleMaxHeight());
        cmds.add(new CommandScaleMaxWidthAndHeight());
        cmds.add(new CommandAffineTransform());
        cmds.add(new CommandAffineTransformMultiline());
        CommandFactorySprite factorySpriteCommand = new CommandFactorySprite();
        cmds.add(factorySpriteCommand.createMultiLine(false));
        cmds.add(factorySpriteCommand.createSingleLine());
        cmds.add(new CommandSpriteFile());
        cmds.add(new CommandStyleMultilinesCSS());
        cmds.add(new CommandStyleImport());
    }

    protected final void addCommonHides(List<Command> cmds) {
        cmds.add(new CommandHideEmptyDescription());
        cmds.add(new CommandHideUnlinked());
        cmds.add(new CommandHideShowByVisibility());
        cmds.add(new CommandHideShowByGender());
    }

    protected final void addTitleCommands(List<Command> cmds) {
        cmds.add(new CommandTitle());
        cmds.add(new CommandMainframe());
        cmds.add(new CommandCaption());
        cmds.add(new CommandMultilinesCaption());
        cmds.add(new CommandMultilinesTitle());
        cmds.add(new CommandMultilinesLegend());
        cmds.add(new CommandFooter());
        cmds.add(new CommandMultilinesFooter());
        cmds.add(new CommandHeader());
        cmds.add(new CommandMultilinesHeader());
    }

    public final List<String> getDescription() {
        ArrayList<String> result = new ArrayList<String>();
        for (Command cmd : this.createCommands()) {
            result.addAll(Arrays.asList(cmd.getDescription()));
        }
        return Collections.unmodifiableList(result);
    }

    static class Step {
        final Command command;
        final BlocLines blocLines;

        Step(Command command, BlocLines blocLines) {
            this.command = command;
            this.blocLines = blocLines;
        }
    }
}

