/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.command;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.FontPosition;

public class CommandCreoleExposantChange
implements Command {
    private final Pattern2 pattern;
    private final FontPosition position;

    private CommandCreoleExposantChange(String p, FontPosition position) {
        this.pattern = MyPattern.cmpile(p);
        this.position = position;
    }

    public static Command create(FontPosition position) {
        return new CommandCreoleExposantChange("^(?i)(\\<" + position.getHtmlTag() + "\\>" + "(.*?)\\</" + position.getHtmlTag() + "\\>)", position);
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(2).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = fc1.changeFontPosition(this.position);
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m3.group(2));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m3.group(1).length());
    }
}

