/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.cute.CuteShape;
import znaishaded.net.sourceforge.plantuml.cute.RotationZoom;
import znaishaded.net.sourceforge.plantuml.cute.VarArgs;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;

public class Stick
implements CuteShape {
    private final double width;
    private final double height;
    private final RotationZoom rotationZoom;

    public Stick(VarArgs varArgs) {
        Point2D dim = varArgs.getAsPoint("dimension");
        this.width = dim.getX();
        this.height = dim.getY();
        this.rotationZoom = RotationZoom.none();
    }

    private Stick(double width, double height, RotationZoom rotation) {
        this.width = width;
        this.height = height;
        this.rotationZoom = rotation;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.width > this.height) {
            this.drawRotate1(ug);
        } else {
            this.drawRotate2(ug);
        }
    }

    private void drawRotate1(UGraphic ug) {
        assert (this.width > this.height);
        UPath path = new UPath();
        double small = this.height / 2.0;
        path.moveTo(this.rotationZoom.getPoint(small, 0.0));
        path.lineTo(this.rotationZoom.getPoint(this.width - small, 0.0));
        path.arcTo(this.rotationZoom.getPoint(this.width - small, this.height), small, 0.0, 1.0);
        path.lineTo(this.rotationZoom.getPoint(small, this.height));
        path.arcTo(this.rotationZoom.getPoint(small, 0.0), small, 0.0, 1.0);
        path.closePath();
        ug.draw(path);
    }

    private void drawRotate2(UGraphic ug) {
        assert (this.height > this.width);
        UPath path = new UPath();
        double small = this.width / 2.0;
        path.moveTo(this.rotationZoom.getPoint(this.width, small));
        path.lineTo(this.rotationZoom.getPoint(this.width, this.height - small));
        path.arcTo(this.rotationZoom.getPoint(0.0, this.height - small), small, 0.0, 1.0);
        path.lineTo(this.rotationZoom.getPoint(0.0, small));
        path.arcTo(this.rotationZoom.getPoint(this.width, small), small, 0.0, 1.0);
        path.closePath();
        ug.draw(path);
    }

    @Override
    public Stick rotateZoom(RotationZoom other) {
        return new Stick(this.width, this.height, this.rotationZoom.compose(other));
    }
}

