/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.Guillemet;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.SkinParameter;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.TextBlockInEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageRequirement
extends AbstractEntityImage {
    private final TextBlock desc;
    private final Url url;

    public EntityImageRequirement(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        BodyEnhanced tmp = new BodyEnhanced(entity.getDisplay(), FontParam.REQUIREMENT, skinParam, HorizontalAlignment.CENTER, stereotype, true, false, entity, SName.componentDiagram);
        if (stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null) {
            this.desc = tmp;
        } else {
            TextBlock stereo = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.REQUIREMENT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
            this.desc = TextBlockUtils.mergeTB(stereo, tmp, HorizontalAlignment.CENTER);
        }
        this.url = entity.getUrl99();
    }

    private UStroke getStroke() {
        UStroke stroke = this.getSkinParam().getThickness(LineParam.requirementBorder, this.getStereo());
        if (stroke == null) {
            stroke = new UStroke(7.0, 7.0, 1.5);
        }
        return stroke;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new TextBlockInEllipse(this.desc, stringBounder).calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        TextBlockInEllipse ellipse = new TextBlockInEllipse(this.desc, stringBounder);
        if (this.getSkinParam().shadowing2(this.getStereo(), SkinParameter.USECASE)) {
            ellipse.setDeltaShadow(3.0);
        }
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(this.getStroke());
        HColor linecolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.LINE);
        if (linecolor == null) {
            linecolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.requirementBorder);
        }
        ug = ug.apply(linecolor);
        HColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.requirementBackground);
        }
        ug = ug.apply(backcolor.bg());
        MyUGraphicEllipse ug2 = new MyUGraphicEllipse(ug, 0.0, 0.0, ellipse.getUEllipse());
        ellipse.drawU(ug2);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.OVAL;
    }

    static class MyUGraphicEllipse
    extends AbstractUGraphicHorizontalLine {
        private final double startingX;
        private final double yTheoricalPosition;
        private final UEllipse ellipse;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicEllipse(ug, this.startingX, this.yTheoricalPosition, this.ellipse);
        }

        MyUGraphicEllipse(UGraphic ug, double startingX, double yTheoricalPosition, UEllipse ellipse) {
            super(ug);
            this.startingX = startingX;
            this.ellipse = ellipse;
            this.yTheoricalPosition = yTheoricalPosition;
        }

        private double getNormalized(double y) {
            if (y < this.yTheoricalPosition) {
                throw new IllegalArgumentException();
            }
            if ((y -= this.yTheoricalPosition) > this.ellipse.getHeight()) {
                throw new IllegalArgumentException();
            }
            return y;
        }

        private double getStartingXInternal(double y) {
            return this.startingX + this.ellipse.getStartingX(this.getNormalized(y));
        }

        private double getEndingXInternal(double y) {
            return this.startingX + this.ellipse.getEndingX(this.getNormalized(y));
        }

        private Stencil getStencil2(UTranslate translate) {
            final double dy = translate.getDy();
            return new Stencil(){

                @Override
                public double getStartingX(StringBounder stringBounder, double y) {
                    return MyUGraphicEllipse.this.getStartingXInternal(y + dy);
                }

                @Override
                public double getEndingX(StringBounder stringBounder, double y) {
                    return MyUGraphicEllipse.this.getEndingXInternal(y + dy);
                }
            };
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            UStroke stroke = new UStroke(1.5);
            line.drawLineInternal(ug.apply(translate), this.getStencil2(translate), 0.0, stroke);
        }
    }
}

