/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentDouble;

public class Frame {
    private double x;
    private double y;
    private final int width;
    private final int height;

    public Frame(double x, double y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    LineSegmentDouble getSide1() {
        return new LineSegmentDouble(this.x, this.y, this.x, this.y + (double)this.height);
    }

    LineSegmentDouble getSide2() {
        return new LineSegmentDouble(this.x, this.y, this.x + (double)this.width, this.y);
    }

    LineSegmentDouble getSide3() {
        return new LineSegmentDouble(this.x + (double)this.width, this.y, this.x + (double)this.width, this.y + (double)this.height);
    }

    LineSegmentDouble getSide4() {
        return new LineSegmentDouble(this.x, this.y + (double)this.height, this.x + (double)this.width, this.y + (double)this.height);
    }

    public Point2D getFrontierPointViewBy(Point2D point) {
        LineSegmentDouble seg = new LineSegmentDouble(point, this.getCenter());
        Point2D p = seg.getSegIntersection(this.getSide1());
        if (p != null) {
            return p;
        }
        p = seg.getSegIntersection(this.getSide2());
        if (p != null) {
            return p;
        }
        p = seg.getSegIntersection(this.getSide3());
        if (p != null) {
            return p;
        }
        p = seg.getSegIntersection(this.getSide4());
        if (p != null) {
            return p;
        }
        return null;
    }

    private Point2D getCenter() {
        return new Point2D.Double(this.x + (double)this.width / 2.0, this.y + (double)this.height / 2.0);
    }

    public Point2D getMainCorner() {
        return new Point2D.Double(this.x, this.y);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }
}

