/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class SegmentCutter {
    private final List<Point2D> intermediates = new ArrayList<Point2D>();

    public SegmentCutter(Point2D start, Point2D end, double maxDistance) {
        double d = end.distance(start);
        if (d <= maxDistance) {
            this.intermediates.add(end);
            return;
        }
        int nb = 2;
        while (d / (double)nb > maxDistance) {
            ++nb;
        }
        double deltaX = end.getX() - start.getX();
        double deltaY = end.getY() - start.getY();
        for (int i = 1; i < nb; ++i) {
            this.intermediates.add(new Point2D.Double(start.getX() + (double)i * deltaX / (double)nb, start.getY() + (double)i * deltaY / (double)nb));
        }
        this.intermediates.add(end);
    }

    public List<Point2D> intermediates() {
        return Collections.unmodifiableList(this.intermediates);
    }
}

