/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;
import znaishaded.net.sourceforge.plantuml.geom.Box;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.PolylineBreakeable;

public class GeneralPathFactory {
    private final LinkType linkType;

    public GeneralPathFactory(LinkType linkType) {
        this.linkType = linkType;
    }

    public Shape getLink(PolylineBreakeable polyline, Box b1, Box b2) {
        LineSegmentInt directSegment = new LineSegmentInt(b1.getCenterX(), b1.getCenterY(), b2.getCenterX(), b2.getCenterY());
        assert (b1.intersect(directSegment).length == 1);
        assert (b2.intersect(directSegment).length == 1);
        GeneralPath generalPath = polyline.asGeneralPath();
        return generalPath;
    }

    private void addSymbol(GeneralPath generalPath, Point2D.Double firstPoint, LineSegmentInt firstSeg, Point2D.Double lastPoint, LineSegmentInt lastSeg) {
    }

    private void addSymbolDiamond(GeneralPath generalPath, Point2D.Double point, LineSegmentInt seg) {
        Polygon arrow = new Polygon();
        arrow.addPoint(0, 0);
        arrow.addPoint(-10, 6);
        arrow.addPoint(-20, 0);
        arrow.addPoint(-10, -6);
        this.appendAndRotate(generalPath, point, seg, arrow);
    }

    private void addSymbolDiamondInv(GeneralPath generalPath, Point2D.Double point, LineSegmentInt seg) {
        Polygon arrow = new Polygon();
        arrow.addPoint(0, 0);
        arrow.addPoint(10, 6);
        arrow.addPoint(20, 0);
        arrow.addPoint(10, -6);
        this.appendAndRotate(generalPath, point, seg, arrow);
    }

    private void addSymbolNavasocInv(GeneralPath generalPath, Point2D.Double point, LineSegmentInt seg) {
        Polygon arrow = new Polygon();
        arrow.addPoint(0, 0);
        arrow.addPoint(13, -8);
        arrow.addPoint(6, 0);
        arrow.addPoint(13, 8);
        this.appendAndRotate(generalPath, point, seg, arrow);
    }

    private void addSymbolNavasoc(GeneralPath generalPath, Point2D.Double point, LineSegmentInt seg) {
        Polygon arrow = new Polygon();
        arrow.addPoint(0, 0);
        arrow.addPoint(-13, -8);
        arrow.addPoint(-6, 0);
        arrow.addPoint(-13, 8);
        this.appendAndRotate(generalPath, point, seg, arrow);
    }

    private void addSymbolExtends(GeneralPath generalPath, Point2D.Double point, LineSegmentInt seg) {
        Polygon arrow = new Polygon();
        arrow.addPoint(0, 0);
        arrow.addPoint(25, 7);
        arrow.addPoint(25, -7);
        this.appendAndRotate(generalPath, point, seg, arrow);
    }

    private void addSymbolExtendsInv(GeneralPath generalPath, Point2D.Double point, LineSegmentInt seg) {
        Polygon arrow = new Polygon();
        arrow.addPoint(0, 0);
        arrow.addPoint(-25, 7);
        arrow.addPoint(-25, -7);
        this.appendAndRotate(generalPath, point, seg, arrow);
    }

    private void appendAndRotate(GeneralPath generalPath, Point2D.Double point, LineSegmentInt seg, Shape shape) {
        AffineTransform at = AffineTransform.getTranslateInstance(point.x, point.y);
        double theta = seg.getAngle();
        at.rotate(theta);
        Shape r = at.createTransformedShape(shape);
        generalPath.append(r, false);
    }
}

