/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.nwdiag;

import java.util.HashSet;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.nwdiag.LinkedElement;
import znaishaded.net.sourceforge.plantuml.nwdiag.Network;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class DiagGroup {
    private final String name;
    private final Network network;
    private final Set<String> elements = new HashSet<String>();
    private HColor color;

    public String toString() {
        return this.name + " " + this.network + " " + this.elements;
    }

    public DiagGroup(String name, Network network) {
        this.name = name;
        this.network = network;
    }

    public final String getName() {
        return this.name;
    }

    public void addElement(String name) {
        this.elements.add(name);
    }

    public boolean matches(LinkedElement tested) {
        if (this.network != null && this.network != tested.getNetwork()) {
            return false;
        }
        return this.elements.contains(tested.getElement().getName());
    }

    public final HColor getColor() {
        return this.color;
    }

    public final void setColor(HColor color) {
        this.color = color;
    }
}

