/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.DisplaySection;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class PngTitler {
    private final HColor textColor;
    private final HColor hyperlinkColor;
    private final DisplaySection text;
    private final int fontSize;
    private final String fontFamily;
    private final boolean useUnderlineForHyperlink;
    private final Style style;
    private final HColorSet set;
    private final ISkinSimple spriteContainer;

    public PngTitler(HColor textColor, DisplaySection text, int fontSize, String fontFamily, HColor hyperlinkColor, boolean useUnderlineForHyperlink, Style style, HColorSet set, ISkinSimple spriteContainer) {
        this.style = style;
        this.set = set;
        this.spriteContainer = spriteContainer;
        if (SkinParam.USE_STYLES()) {
            textColor = style.value(PName.FontColor).asColor(set);
            fontSize = style.value(PName.FontSize).asInt();
            fontFamily = style.value(PName.FontName).asString();
            hyperlinkColor = style.value(PName.HyperLinkColor).asColor(set);
        }
        this.textColor = textColor;
        this.text = text;
        this.fontSize = fontSize;
        this.fontFamily = fontFamily;
        this.hyperlinkColor = hyperlinkColor;
        this.useUnderlineForHyperlink = useUnderlineForHyperlink;
    }

    public Dimension2D getTextDimension(StringBounder stringBounder) {
        TextBlock textBloc = this.getRibbonBlock();
        if (textBloc == null) {
            return null;
        }
        return textBloc.calculateDimension(stringBounder);
    }

    public TextBlock getRibbonBlock() {
        if (SkinParam.USE_STYLES()) {
            Display display = this.text.getDisplay();
            if (display == null) {
                return null;
            }
            return this.style.createTextBlockBordered(display, this.set, this.spriteContainer);
        }
        UFont normalFont = new UFont(this.fontFamily, 0, this.fontSize);
        return this.text.createRibbon(new FontConfiguration(normalFont, this.textColor, this.hyperlinkColor, this.useUnderlineForHyperlink), new SpriteContainerEmpty());
    }
}

