/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLine;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLineReader;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLineSimple;
import znaishaded.net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import znaishaded.net.sourceforge.plantuml.preproc.Stdlib;
import znaishaded.net.sourceforge.plantuml.security.SURL;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;

public class PreprocessorUtils {
    public static String withEnvironmentVariable(String s2) {
        Pattern p = Pattern.compile("%(\\w+)%");
        Matcher m3 = p.matcher(s2);
        StringBuffer sb = new StringBuffer();
        while (m3.find()) {
            String var = m3.group(1);
            String value = PreprocessorUtils.getenv(var);
            if (value == null) continue;
            m3.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        m3.appendTail(sb);
        s2 = sb.toString();
        return s2;
    }

    public static String getenv(String var) {
        String env = System.getProperty(var);
        if (StringUtils.isNotEmpty(env)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env);
        }
        String getenv = System.getenv(var);
        if (StringUtils.isNotEmpty(getenv)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(getenv);
        }
        return null;
    }

    private static InputStream getStdlibInputStream(String filename) {
        InputStream result = Stdlib.getResourceAsStream(filename);
        return result;
    }

    public static ReadLine getReaderStdlibInclude(StringLocated s2, String filename) {
        Log.info("Loading sdlib " + filename);
        InputStream is = PreprocessorUtils.getStdlibInputStream(filename);
        if (is == null) {
            return null;
        }
        String description = "<" + filename + ">";
        try {
            if (StartDiagramExtractReader.containsStartDiagram(is, s2, description)) {
                is = PreprocessorUtils.getStdlibInputStream(filename);
                return StartDiagramExtractReader.build(is, s2, description);
            }
            is = PreprocessorUtils.getStdlibInputStream(filename);
            if (is == null) {
                return null;
            }
            return ReadLineReader.create(new InputStreamReader(is), description);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ReadLineSimple(s2, e.toString());
        }
    }

    public static ReadLine getReaderIncludeUrl2(SURL url, StringLocated s2, String suf, String charset) throws EaterException {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(url, s2, charset)) {
                return StartDiagramExtractReader.build(url, s2, suf, charset);
            }
            InputStream is = url.openStream();
            if (is == null) {
                throw EaterException.located("Cannot open URL");
            }
            if (charset == null) {
                Log.info("Using default charset");
                return ReadLineReader.create(new InputStreamReader(is), url.toString(), s2.getLocation());
            }
            Log.info("Using charset " + charset);
            return ReadLineReader.create(new InputStreamReader(is, charset), url.toString(), s2.getLocation());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw EaterException.located("Cannot open URL " + e.getMessage());
        }
    }
}

