/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.AnnotatedWorker;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.Scale;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.project.GanttConstraint;
import znaishaded.net.sourceforge.plantuml.project.LoadPlanable;
import znaishaded.net.sourceforge.plantuml.project.ToTaskDraw;
import znaishaded.net.sourceforge.plantuml.project.core.Moment;
import znaishaded.net.sourceforge.plantuml.project.core.MomentImpl;
import znaishaded.net.sourceforge.plantuml.project.core.PrintScale;
import znaishaded.net.sourceforge.plantuml.project.core.Resource;
import znaishaded.net.sourceforge.plantuml.project.core.Task;
import znaishaded.net.sourceforge.plantuml.project.core.TaskAttribute;
import znaishaded.net.sourceforge.plantuml.project.core.TaskCode;
import znaishaded.net.sourceforge.plantuml.project.core.TaskImpl;
import znaishaded.net.sourceforge.plantuml.project.core.TaskInstant;
import znaishaded.net.sourceforge.plantuml.project.core.TaskSeparator;
import znaishaded.net.sourceforge.plantuml.project.draw.ResourceDraw;
import znaishaded.net.sourceforge.plantuml.project.draw.TaskDraw;
import znaishaded.net.sourceforge.plantuml.project.draw.TaskDrawDiamond;
import znaishaded.net.sourceforge.plantuml.project.draw.TaskDrawRegular;
import znaishaded.net.sourceforge.plantuml.project.draw.TaskDrawSeparator;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeader;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeaderDaily;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeaderMonthly;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeaderSimple;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeaderWeekly;
import znaishaded.net.sourceforge.plantuml.project.lang.CenterBorderColor;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.time.GCalendar;
import znaishaded.net.sourceforge.plantuml.project.time.Wink;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class GanttDiagram
extends TitledDiagram
implements ToTaskDraw {
    private final Map<TaskCode, Task> tasks = new LinkedHashMap<TaskCode, Task>();
    private final Map<String, Task> byShortName = new HashMap<String, Task>();
    private final List<GanttConstraint> constraints = new ArrayList<GanttConstraint>();
    private final HColorSet colorSet = HColorSet.instance();
    private final Collection<DayOfWeek> closedDayOfWeek = EnumSet.noneOf(DayOfWeek.class);
    private final Collection<Day> closedDayAsDate = new HashSet<Day>();
    private final Collection<Day> openedDayAsDate = new HashSet<Day>();
    private final Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    private final Map<Day, HColor> colorDays = new HashMap<Day, HColor>();
    private final Map<Day, String> nameDays = new HashMap<Day, String>();
    private PrintScale printScale = PrintScale.DAILY;
    private Day today;
    private GCalendar calendar;
    private double totalHeight;
    private Wink min = new Wink(0);
    private Wink max;
    private Day printStart;
    private Day printEnd;
    private HColor linksColor = HColorUtils.RED_DARK;
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private final Map<Task, TaskDraw> draws = new LinkedHashMap<Task, TaskDraw>();

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Project)");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.GANTT;
    }

    public final int getHorizontalPages() {
        return this.horizontalPages;
    }

    public final void setHorizontalPages(int horizontalPages) {
        this.horizontalPages = horizontalPages;
    }

    public final int getVerticalPages() {
        return this.verticalPages;
    }

    public final void setVerticalPages(int verticalPages) {
        this.verticalPages = verticalPages;
    }

    @Override
    public int getNbImages() {
        return this.horizontalPages * this.verticalPages;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return 96;
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption, long seed) throws IOException {
        int margin2;
        int margin1;
        Scale scale = this.getScale();
        if (SkinParam.USE_STYLES()) {
            margin1 = SkinParam.zeroMargin(0);
            margin2 = SkinParam.zeroMargin(0);
        } else {
            margin1 = 0;
            margin2 = 0;
        }
        double dpiFactor = scale == null ? 1.0 : scale.getScale(100.0, 100.0);
        ImageBuilder imageBuilder = ImageBuilder.buildB(new ColorMapperIdentity(), false, ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2), null, this.getMetadata(), "", dpiFactor, null);
        TextBlockBackcolored result = this.getTextBlock();
        result = new AnnotatedWorker(this, this.getSkinParam(), fileFormatOption.getDefaultStringBounder()).addAdd(result);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, seed, os);
    }

    public void setPrintScale(PrintScale printScale) {
        this.printScale = printScale;
    }

    private boolean isHidden(Task task) {
        if (this.printStart == null || task instanceof TaskSeparator) {
            return false;
        }
        if (task.getEnd().compareTo(this.min) < 0) {
            return true;
        }
        return task.getStart().compareTo(this.max) > 0;
    }

    private TextBlockBackcolored getTextBlock() {
        if (this.printStart == null) {
            this.initMinMax();
        } else {
            this.min = this.calendar.fromDayAsDate(this.printStart);
            this.max = this.calendar.fromDayAsDate(this.printEnd);
        }
        final TimeHeader timeHeader = this.calendar == null ? new TimeHeaderSimple(this.min, this.max) : (this.printScale == PrintScale.WEEKLY ? new TimeHeaderWeekly(this.calendar, this.min, this.max, this.getDefaultPlan(), this.colorDays, this.nameDays) : (this.printScale == PrintScale.MONTHLY ? new TimeHeaderMonthly(this.calendar, this.min, this.max, this.getDefaultPlan(), this.colorDays, this.nameDays) : new TimeHeaderDaily(this.calendar, this.min, this.max, this.getDefaultPlan(), this.colorDays, this.nameDays, this.printStart, this.printEnd)));
        this.initTaskAndResourceDraws(timeHeader.getTimeScale(), ((TimeHeader)timeHeader).getFullHeaderHeight());
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                timeHeader.drawTimeHeader(ug, GanttDiagram.this.totalHeight);
                GanttDiagram.this.drawConstraints(ug, timeHeader.getTimeScale());
                GanttDiagram.this.drawTasksRect(ug);
                GanttDiagram.this.drawTasksTitle(ug);
                GanttDiagram.this.drawResources(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double xmin = timeHeader.getTimeScale().getStartingPosition(GanttDiagram.this.min);
                double xmax = timeHeader.getTimeScale().getEndingPosition(GanttDiagram.this.max);
                return new Dimension2DDouble(xmax - xmin, GanttDiagram.this.totalHeight);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawTasksRect(UGraphic ug) {
        for (Task task : this.tasks.values()) {
            TaskDraw draw = this.draws.get(task);
            UTranslate move = UTranslate.dy(draw.getY());
            draw.drawU(ug.apply(move));
        }
    }

    private void drawConstraints(UGraphic ug, TimeScale timeScale) {
        for (GanttConstraint constraint : this.constraints) {
            if (this.printStart != null && constraint.isHidden(this.min, this.max)) continue;
            constraint.getUDrawable(timeScale, this.linksColor, this).drawU(ug);
        }
    }

    private void drawTasksTitle(UGraphic ug1) {
        for (Task task : this.tasks.values()) {
            if (this.isHidden(task)) continue;
            TaskDraw draw = this.draws.get(task);
            UTranslate move = UTranslate.dy(draw.getY());
            draw.drawTitle(ug1.apply(move));
        }
    }

    private void drawResources(UGraphic ug) {
        for (Resource res : this.resources.values()) {
            ResourceDraw draw = res.getResourceDraw();
            UTranslate move = UTranslate.dy(draw.getY());
            draw.drawU(ug.apply(move));
        }
    }

    public final LoadPlanable getDefaultPlan() {
        return new LoadPlanable(){

            @Override
            public int getLoadAt(Wink instant) {
                if (GanttDiagram.this.calendar == null) {
                    return 100;
                }
                Day day = GanttDiagram.this.calendar.toDayAsDate(instant);
                if (GanttDiagram.this.isClosed(day)) {
                    return 0;
                }
                return 100;
            }
        };
    }

    private boolean isClosed(Day day) {
        if (this.openedDayAsDate.contains(day)) {
            return false;
        }
        DayOfWeek dayOfWeek = day.getDayOfWeek();
        return this.closedDayOfWeek.contains((Object)dayOfWeek) || this.closedDayAsDate.contains(day);
    }

    public void closeDayOfWeek(DayOfWeek day) {
        this.closedDayOfWeek.add(day);
    }

    public void closeDayAsDate(Day day) {
        this.closedDayAsDate.add(day);
    }

    public void openDayAsDate(Day day) {
        this.openedDayAsDate.add(day);
    }

    private void initTaskAndResourceDraws(TimeScale timeScale, double headerHeight) {
        UDrawable draw;
        double y = headerHeight;
        for (Task task : this.tasks.values()) {
            if (task instanceof TaskSeparator) {
                draw = new TaskDrawSeparator(((TaskSeparator)task).getName(), timeScale, y, this.min, this.max);
            } else {
                TaskImpl tmp = (TaskImpl)task;
                if (tmp.isDiamond()) {
                    draw = new TaskDrawDiamond(timeScale, y, tmp.getPrettyDisplay(), this.getStart(tmp), this.getSkinParam(), task, this);
                } else {
                    boolean oddStart = this.printStart != null && this.min.compareTo(this.getStart(tmp)) == 0;
                    boolean oddEnd = this.printStart != null && this.max.compareTo(this.getEnd(tmp)) == 0;
                    draw = new TaskDrawRegular(timeScale, y, tmp.getPrettyDisplay(), this.getStart(tmp), this.getEnd(tmp), oddStart, oddEnd, this.getSkinParam(), task, this);
                }
                draw.setColorsAndCompletion(tmp.getColors(), tmp.getCompletion(), tmp.getUrl(), tmp.getNote());
            }
            if (task.getRow() == null) {
                y += draw.getHeight();
            }
            this.draws.put(task, (TaskDraw)draw);
        }
        for (Resource res : this.resources.values()) {
            draw = new ResourceDraw(this, res, timeScale, y, this.min, this.max);
            res.setTaskDraw((ResourceDraw)draw);
            y += ((ResourceDraw)draw).getHeight();
        }
        this.totalHeight = y;
    }

    private Wink getStart(TaskImpl tmp) {
        if (this.printStart == null) {
            return tmp.getStart();
        }
        return Wink.max(this.min, tmp.getStart());
    }

    private Wink getEnd(TaskImpl tmp) {
        if (this.printStart == null) {
            return tmp.getEnd();
        }
        return Wink.min(this.max, tmp.getEnd());
    }

    private void initMinMax() {
        if (this.tasks.size() == 0) {
            this.max = this.min.increment();
        } else {
            this.max = null;
            for (Task task : this.tasks.values()) {
                if (task instanceof TaskSeparator) continue;
                Wink start = task.getStart();
                Wink end = task.getEnd();
                if (this.max != null && this.max.compareTo(end) >= 0) continue;
                this.max = end;
            }
        }
        if (this.calendar != null) {
            Wink instant;
            for (Day d : this.colorDays.keySet()) {
                instant = this.calendar.fromDayAsDate(d);
                if (instant.compareTo(this.max) <= 0) continue;
                this.max = instant;
            }
            for (Day d : this.nameDays.keySet()) {
                instant = this.calendar.fromDayAsDate(d);
                if (instant.compareTo(this.max) <= 0) continue;
                this.max = instant;
            }
        }
    }

    public Day getThenDate() {
        Day result = this.getStartingDate();
        for (Day d : this.colorDays.keySet()) {
            if (d.compareTo(result) <= 0) continue;
            result = d;
        }
        for (Day d : this.nameDays.keySet()) {
            if (d.compareTo(result) <= 0) continue;
            result = d;
        }
        return result;
    }

    public Task getExistingTask(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        Task result = this.byShortName.get(id);
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(id);
        return this.tasks.get(code);
    }

    public GanttConstraint forceTaskOrder(Task task1, Task task2) {
        TaskInstant end1 = new TaskInstant(task1, TaskAttribute.END);
        task2.setStart(end1.getInstantPrecise());
        GanttConstraint result = new GanttConstraint(end1, new TaskInstant(task2, TaskAttribute.START));
        this.addContraint(result);
        return result;
    }

    public Task getOrCreateTask(String codeOrShortName, String shortName, boolean linkedToPrevious) {
        Task result;
        if (codeOrShortName == null) {
            throw new IllegalArgumentException();
        }
        Task task = result = shortName == null ? null : this.byShortName.get(shortName);
        if (result != null) {
            return result;
        }
        result = this.byShortName.get(codeOrShortName);
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(codeOrShortName);
        result = this.tasks.get(code);
        if (result == null) {
            Task previous = null;
            if (linkedToPrevious) {
                previous = this.getLastCreatedTask();
            }
            result = new TaskImpl(code, this.getDefaultPlan(), this.calendar);
            this.tasks.put(code, result);
            if (this.byShortName != null) {
                this.byShortName.put(shortName, result);
            }
            if (previous != null) {
                this.forceTaskOrder(previous, result);
            }
        }
        return result;
    }

    private Task getLastCreatedTask() {
        ArrayList<Task> all = new ArrayList<Task>(this.tasks.values());
        for (int i = all.size() - 1; i >= 0; --i) {
            if (!(all.get(i) instanceof TaskImpl)) continue;
            return (Task)all.get(i);
        }
        return null;
    }

    public void addSeparator(String comment) {
        TaskSeparator separator = new TaskSeparator(comment, this.tasks.size());
        this.tasks.put(separator.getCode(), separator);
    }

    public void addContraint(GanttConstraint constraint) {
        this.constraints.add(constraint);
    }

    public HColorSet getIHtmlColorSet() {
        return this.colorSet;
    }

    public void setStartingDate(Day start) {
        this.calendar = new GCalendar(start);
    }

    public Day getStartingDate() {
        if (this.calendar == null) {
            return null;
        }
        return this.calendar.getStartingDate();
    }

    public Day getStartingDate(int nday) {
        if (this.calendar == null) {
            return null;
        }
        return this.calendar.toDayAsDate(new Wink(nday));
    }

    public int daysInWeek() {
        return 7 - this.closedDayOfWeek.size();
    }

    public Wink convert(Day day) {
        return this.calendar.fromDayAsDate(day);
    }

    public boolean isOpen(Day day) {
        return this.getDefaultPlan().getLoadAt(this.convert(day)) > 0;
    }

    public void affectResource(Task result, String description) {
        Pattern p = Pattern.compile("([^:]+)(:(\\d+))?");
        Matcher m3 = p.matcher(description);
        if (!m3.find()) {
            throw new IllegalArgumentException();
        }
        Resource resource = this.getResource(m3.group(1));
        int percentage = 100;
        if (m3.group(3) != null) {
            percentage = Integer.parseInt(m3.group(3));
        }
        result.addResource(resource, percentage);
    }

    public Resource getResource(String resourceName) {
        Resource resource = this.resources.get(resourceName);
        if (resource == null) {
            resource = new Resource(resourceName, this.getDefaultPlan(), this.calendar);
        }
        this.resources.put(resourceName, resource);
        return resource;
    }

    public int getLoadForResource(Resource res, Wink i) {
        int result = 0;
        for (Task task : this.tasks.values()) {
            if (task instanceof TaskSeparator) continue;
            TaskImpl task2 = (TaskImpl)task;
            result += task2.loadForResource(res, i);
        }
        return result;
    }

    public Moment getExistingMoment(String id) {
        Moment result = this.getExistingTask(id);
        if (result == null) {
            Day start = null;
            Day end = null;
            for (Map.Entry<Day, String> ent : this.nameDays.entrySet()) {
                if (!ent.getValue().equalsIgnoreCase(id)) continue;
                start = this.min(start, ent.getKey());
                end = this.max(end, ent.getKey());
            }
            if (start != null) {
                result = new MomentImpl(this.convert(start), this.convert(end));
            }
        }
        return result;
    }

    private Day min(Day d1, Day d2) {
        if (d1 == null) {
            return d2;
        }
        if (d1.compareTo(d2) > 0) {
            return d2;
        }
        return d1;
    }

    private Day max(Day d1, Day d2) {
        if (d1 == null) {
            return d2;
        }
        if (d1.compareTo(d2) < 0) {
            return d2;
        }
        return d1;
    }

    public void colorDay(Day day, HColor color) {
        this.colorDays.put(day, color);
    }

    public void nameDay(Day day, String name) {
        this.nameDays.put(day, name);
    }

    public void setTodayColors(CenterBorderColor colors) {
        if (this.today == null) {
            this.today = Day.today();
        }
        this.colorDay(this.today, colors.getCenter());
    }

    public CommandExecutionResult setToday(Day date) {
        this.today = date;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult deleteTask(Task task) {
        task.setColors(new CenterBorderColor(HColorUtils.WHITE, HColorUtils.BLACK));
        return CommandExecutionResult.ok();
    }

    public void setPrintInterval(Day start, Day end) {
        this.printStart = start;
        this.printEnd = end;
    }

    public void setLinksColor(HColor color) {
        this.linksColor = color;
    }

    @Override
    public TaskDraw getTaskDraw(Task task) {
        return this.draws.get(task);
    }

    public CommandExecutionResult addNote(Display note) {
        Task last = null;
        Iterator<Task> iterator = this.tasks.values().iterator();
        while (iterator.hasNext()) {
            Task current;
            last = current = iterator.next();
        }
        if (last == null) {
            return CommandExecutionResult.error("No task defined");
        }
        last.setNote(note);
        return CommandExecutionResult.ok();
    }
}

