/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.project.Failable;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.core.Task;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceDisplayOnSameRowAs;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceEnds;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceHappens;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceHappensDate;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceIsColored;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceIsDeleted;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceIsForTask;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceLasts;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceLinksTo;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceOccurs;
import znaishaded.net.sourceforge.plantuml.project.lang.SentencePausesDate;
import znaishaded.net.sourceforge.plantuml.project.lang.SentencePausesDayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceSimple;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceTaskEndsAbsolute;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceTaskStarts;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceTaskStartsAbsolute;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceTaskStartsWithColor;
import znaishaded.net.sourceforge.plantuml.project.lang.Subject;

public class SubjectTask
implements Subject {
    public Failable<Task> getMe(GanttDiagram project, RegexResult arg) {
        String s2 = arg.get("SUBJECT", 0);
        String shortName = arg.get("SUBJECT", 1);
        String then = arg.get("THEN", 0);
        String resource = arg.get("RESOURCE", 0);
        Task result = project.getOrCreateTask(s2, shortName, then != null);
        if (result == null) {
            throw new IllegalStateException();
        }
        if (resource != null) {
            StringTokenizer st = new StringTokenizer(resource, "{}");
            while (st.hasMoreTokens()) {
                String part = st.nextToken().trim();
                if (part.length() <= 0) continue;
                project.affectResource(result, part);
            }
        }
        return Failable.ok(result);
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new SentenceLasts(), new SentenceTaskStarts(), new SentenceTaskStartsWithColor(), new SentenceTaskStartsAbsolute(), new SentenceHappens(), new SentenceHappensDate(), new SentenceEnds(), new SentenceTaskEndsAbsolute(), new SentenceIsColored(), new SentenceIsDeleted(), new SentenceIsForTask(), new SentenceLinksTo(), new SentenceOccurs(), new SentenceDisplayOnSameRowAs(), new SentencePausesDate(), new SentencePausesDayOfWeek());
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("THEN", "(then[%s]+)?"), new RegexLeaf("SUBJECT", "\\[([^\\[\\]]+?)\\](?:[%s]+as[%s]+\\[([^\\[\\]]+?)\\])?"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("on"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("RESOURCE", "((?:\\{[^{}]+\\}[%s]*)+)"))));
    }
}

