/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementEmpty;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class ElementBorder
extends AbstractElement {
    private Element north = new ElementEmpty();
    private Element south = new ElementEmpty();
    private Element east = new ElementEmpty();
    private Element west = new ElementEmpty();
    private Element center = new ElementEmpty();

    public final void setNorth(Element north) {
        this.north = north;
    }

    public final void setSouth(Element south) {
        this.south = south;
    }

    public final void setEast(Element east) {
        this.east = east;
    }

    public final void setWest(Element west) {
        this.west = west;
    }

    public final void setCenter(Element center) {
        this.center = center;
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimNorth = this.north.getPreferredDimension(stringBounder, 0.0, 0.0);
        Dimension2D dimSouth = this.south.getPreferredDimension(stringBounder, 0.0, 0.0);
        Dimension2D dimEast = this.east.getPreferredDimension(stringBounder, 0.0, 0.0);
        Dimension2D dimWest = this.west.getPreferredDimension(stringBounder, 0.0, 0.0);
        Point2D.Double pA = new Point2D.Double(dimWest.getWidth(), dimNorth.getHeight());
        Point2D.Double pB = new Point2D.Double(dimToUse.getWidth() - dimEast.getWidth(), dimNorth.getHeight());
        Point2D.Double pC = new Point2D.Double(dimWest.getWidth(), dimToUse.getHeight() - dimSouth.getHeight());
        this.north.drawU(ug, zIndex, dimToUse);
        this.south.drawU(ug.apply(UTranslate.dy(((Point2D)pC).getY())), zIndex, dimToUse);
        this.west.drawU(ug.apply(UTranslate.dy(((Point2D)pA).getY())), zIndex, dimToUse);
        this.east.drawU(ug.apply(new UTranslate(((Point2D)pB).getX(), ((Point2D)pB).getY())), zIndex, dimToUse);
        this.center.drawU(ug.apply(new UTranslate(((Point2D)pA).getX(), ((Point2D)pA).getY())), zIndex, dimToUse);
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        Dimension2D dimNorth = this.north.getPreferredDimension(stringBounder, x, y);
        Dimension2D dimSouth = this.south.getPreferredDimension(stringBounder, x, y);
        Dimension2D dimEast = this.east.getPreferredDimension(stringBounder, x, y);
        Dimension2D dimWest = this.west.getPreferredDimension(stringBounder, x, y);
        Dimension2D dimCenter = this.center.getPreferredDimension(stringBounder, x, y);
        double width = MathUtils.max(dimNorth.getWidth(), dimSouth.getWidth(), dimWest.getWidth() + dimCenter.getWidth() + dimEast.getWidth());
        double height = dimNorth.getHeight() + MathUtils.max(dimWest.getHeight(), dimCenter.getHeight(), dimEast.getHeight()) + dimSouth.getHeight();
        return new Dimension2DDouble(width, height);
    }
}

