/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import java.text.DecimalFormat;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandAutonumberResume
extends SingleLineCommand2<SequenceDiagram> {
    public CommandAutonumberResume() {
        super(CommandAutonumberResume.getConcat());
    }

    private static RegexConcat getConcat() {
        return RegexConcat.build(CommandAutonumberResume.class.getName(), RegexLeaf.start(), new RegexLeaf("autonumber"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("resume"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("INC", "(\\d+)"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("DF", "[%g]([^%g]+)[%g]"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        String inc;
        String df = arg.get("DF", 0);
        DecimalFormat decimalFormat = null;
        if (df != null) {
            try {
                decimalFormat = new DecimalFormat(df);
            }
            catch (IllegalArgumentException e) {
                return CommandExecutionResult.error("Error in pattern : " + df);
            }
        }
        if ((inc = arg.get("INC", 0)) == null) {
            diagram.getAutoNumber().resume(decimalFormat);
        } else {
            diagram.getAutoNumber().resume(Integer.parseInt(inc), decimalFormat);
        }
        return CommandExecutionResult.ok();
    }
}

