/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Divider;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class DividerTile
extends AbstractTile
implements Tile {
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Divider divider;
    private final Real origin;
    private final TileArguments tileArguments;

    @Override
    public Event getEvent() {
        return this.divider;
    }

    public DividerTile(Divider divider, TileArguments tileArguments) {
        this.tileArguments = tileArguments;
        this.divider = divider;
        this.skin = tileArguments.getSkin();
        this.skinParam = tileArguments.getSkinParam();
        this.origin = tileArguments.getOrigin();
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponent(this.divider.getUsedStyles(), ComponentType.DIVIDER, null, this.skinParam, this.divider.getText());
        return comp;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = new Area(this.tileArguments.getBorder2() - this.tileArguments.getBorder1() - this.origin.getCurrentValue(), dim.getHeight());
        ug = ug.apply(UTranslate.dx(this.tileArguments.getBorder1()));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim.getHeight();
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.origin;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return this.origin.addFixed(dim.getWidth());
    }
}

