/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.IntegerColored;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;

public class Stairs2 {
    private final List<StairsPosition> ys = new ArrayList<StairsPosition>();
    private final List<IntegerColored> values = new ArrayList<IntegerColored>();
    private final Map<Double, IntegerColored> cache = new HashMap<Double, IntegerColored>();

    public String toString() {
        return this.ys.toString() + " " + this.values;
    }

    public void addStep(StairsPosition position, int value, SymbolContext color) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        assert (this.ys.size() == this.values.size());
        if (this.ys.size() > 0) {
            double lastY = this.ys.get(this.ys.size() - 1).getValue();
            if (position.getValue() <= lastY) {
                return;
            }
            if (lastY == position.getValue()) {
                this.values.set(this.ys.size() - 1, new IntegerColored(value, color));
                this.cache.clear();
                return;
            }
        }
        this.ys.add(position);
        this.values.add(new IntegerColored(value, color));
        this.cache.clear();
    }

    public int getMaxValue() {
        int max = Integer.MIN_VALUE;
        for (IntegerColored vc : this.values) {
            int v = vc.getValue();
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public List<StairsPosition> getYs() {
        return Collections.unmodifiableList(this.ys);
    }

    public IntegerColored getValue(double y) {
        IntegerColored resultc = this.cache.get(y);
        if (resultc == null) {
            resultc = this.getValueSlow(new StairsPosition(y, false));
            this.cache.put(y, resultc);
        }
        return resultc;
    }

    private IntegerColored getValueSlow(StairsPosition y) {
        int idx = Collections.binarySearch(this.ys, y);
        if (idx >= 0) {
            return this.values.get(idx);
        }
        int insertPoint = -idx - 1;
        if (insertPoint == 0) {
            return new IntegerColored(0, null);
        }
        return this.values.get(insertPoint - 1);
    }

    public int getLastValue() {
        int size = this.values.size();
        if (size == 0) {
            return 0;
        }
        return this.values.get(size - 1).getValue();
    }
}

