/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhanced2;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockEmpty;
import znaishaded.net.sourceforge.plantuml.skin.AbstractComponent;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public abstract class AbstractTextualComponent
extends AbstractComponent {
    private final Display display;
    private final int marginX1;
    private final int marginX2;
    private final int marginY;
    private final TextBlock textBlock;
    private final ISkinSimple spriteContainer;
    private final UFont font;
    private final HColor fontColor;

    public AbstractTextualComponent(Style style, LineBreakStrategy maxMessageSize, CharSequence label, FontConfiguration font, HorizontalAlignment horizontalAlignment, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, UFont fontForStereotype, HColor htmlColorForStereotype) {
        this(style, style, maxMessageSize, Display.getWithNewlines(label == null ? "" : label.toString()), font, horizontalAlignment, marginX1, marginX2, marginY, spriteContainer, false, fontForStereotype, htmlColorForStereotype);
    }

    public AbstractTextualComponent(Style style, LineBreakStrategy maxMessageSize, Display display, FontConfiguration fc, HorizontalAlignment horizontalAlignment, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, boolean enhanced, UFont fontForStereotype, HColor htmlColorForStereotype) {
        this(style, style, maxMessageSize, display, fc, horizontalAlignment, marginX1, marginX2, marginY, spriteContainer, enhanced, fontForStereotype, htmlColorForStereotype);
    }

    public AbstractTextualComponent(Style style, Style stereo, LineBreakStrategy maxMessageSize, Display display, FontConfiguration fc, HorizontalAlignment horizontalAlignment, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, boolean enhanced, UFont fontForStereotype, HColor htmlColorForStereotype) {
        super(style);
        this.spriteContainer = spriteContainer;
        if (SkinParam.USE_STYLES()) {
            fc = style.getFontConfiguration(this.getIHtmlColorSet());
            this.font = style.getUFont();
            this.fontColor = style.value(PName.FontColor).asColor(this.getIHtmlColorSet());
            horizontalAlignment = style.getHorizontalAlignment();
            fontForStereotype = stereo.getUFont();
            htmlColorForStereotype = stereo.value(PName.FontColor).asColor(this.getIHtmlColorSet());
            this.display = display.withoutStereotypeIfNeeded(style);
        } else {
            this.font = fc.getFont();
            this.fontColor = fc.getColor();
            this.display = display;
        }
        this.marginX1 = marginX1;
        this.marginX2 = marginX2;
        this.marginY = marginY;
        this.textBlock = this.display.size() == 1 && this.display.get(0).length() == 0 ? new TextBlockEmpty() : (enhanced ? new BodyEnhanced2(this.display, FontParam.NOTE, spriteContainer, horizontalAlignment, fc, maxMessageSize) : this.display.create0(fc, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL, fontForStereotype, htmlColorForStereotype));
    }

    protected HColorSet getIHtmlColorSet() {
        return ((ISkinParam)this.spriteContainer).getIHtmlColorSet();
    }

    protected TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = textBlock.calculateDimension(stringBounder);
        return size.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + (double)this.marginX1 + (double)this.marginX2;
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = textBlock.calculateDimension(stringBounder);
        return size.getHeight() + (double)(2 * this.marginY);
    }

    protected final int getMarginX1() {
        return this.marginX1;
    }

    protected final int getMarginX2() {
        return this.marginX2;
    }

    protected final int getMarginY() {
        return this.marginY;
    }

    protected final UFont getFont() {
        return this.font;
    }

    protected HColor getFontColor() {
        return this.fontColor;
    }

    protected final ISkinSimple getISkinSimple() {
        return this.spriteContainer;
    }
}

