/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Point2D;

public class Circle {
    private Point2D center;
    private double radius;

    public Circle() {
        this(new Point2D.Double());
    }

    public Circle(Point2D center) {
        this.center = center;
        this.radius = 0.0;
    }

    public Circle(Point2D p1, Point2D p2) {
        this.center = new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
        this.radius = p1.distance(this.center);
    }

    public static Circle getCircle(Point2D p1, Point2D p2, Point2D p3) {
        if (p3.getY() != p2.getY()) {
            return new Circle(p1, p2, p3);
        }
        return new Circle(p2, p1, p3);
    }

    private Circle(Point2D p1, Point2D p2, Point2D p3) {
        double num1 = p3.getX() * p3.getX() * (p1.getY() - p2.getY()) + (p1.getX() * p1.getX() + (p1.getY() - p2.getY()) * (p1.getY() - p3.getY())) * (p2.getY() - p3.getY()) + p2.getX() * p2.getX() * (-p1.getY() + p3.getY());
        double den1 = 2.0 * (p3.getX() * (p1.getY() - p2.getY()) + p1.getX() * (p2.getY() - p3.getY()) + p2.getX() * (-p1.getY() + p3.getY()));
        double x = num1 / den1;
        double den2 = p3.getY() - p2.getY();
        double y = (p2.getY() + p3.getY()) / 2.0 - (p3.getX() - p2.getX()) / den2 * (x - (p2.getX() + p3.getX()) / 2.0);
        this.center = new Point2D.Double(x, y);
        this.radius = this.center.distance(p1);
    }

    public Point2D getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean isOutside(Point2D point) {
        double d = this.center.distance(point);
        return d > this.radius;
    }
}

