/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.PathIterator;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;

public class DriverTextAsPathSvg
implements UDriver<SvgGraphics> {
    private final FontRenderContext fontRenderContext;
    private final ClipContainer clipContainer;

    public DriverTextAsPathSvg(FontRenderContext fontRenderContext, ClipContainer clipContainer) {
        this.fontRenderContext = fontRenderContext;
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y)) {
            return;
        }
        UText shape = (UText)ushape;
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        UFont font = fontConfiguration.getFont();
        TextLayout t = new TextLayout(shape.getText(), font.getFont(), this.fontRenderContext);
        DriverTextAsPathSvg.drawPathIterator(svg, x, y, t.getOutline(null).getPathIterator(null));
    }

    static void drawPathIterator(SvgGraphics svg, double x, double y, PathIterator path) {
        svg.newpath();
        double[] coord = new double[6];
        while (!path.isDone()) {
            int code = path.currentSegment(coord);
            if (code == 0) {
                svg.moveto(coord[0] + x, coord[1] + y);
            } else if (code == 1) {
                svg.lineto(coord[0] + x, coord[1] + y);
            } else if (code == 4) {
                svg.closepath();
            } else if (code == 3) {
                svg.curveto(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y, coord[4] + x, coord[5] + y);
            } else if (code == 2) {
                svg.quadto(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y);
            } else {
                throw new UnsupportedOperationException("code=" + code);
            }
            path.next();
        }
        svg.fill(path.getWindingRule());
    }
}

