/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.xmi;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.skin.VisibilityModifier;
import znaishaded.net.sourceforge.plantuml.utils.UniqueSequence;
import znaishaded.net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import znaishaded.net.sourceforge.plantuml.xmi.IXmiClassDiagram;

abstract class XmiClassDiagramAbstract
implements IXmiClassDiagram {
    protected final ClassDiagram classDiagram;
    protected final Document document;
    protected Element ownedElement;
    protected final Set<IEntity> done = new HashSet<IEntity>();

    public XmiClassDiagramAbstract(ClassDiagram classDiagram) throws ParserConfigurationException {
        this.classDiagram = classDiagram;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element xmi = this.document.createElement("XMI");
        xmi.setAttribute("xmi.version", "1.1");
        xmi.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
        this.document.appendChild(xmi);
        Element header = this.document.createElement("XMI.header");
        xmi.appendChild(header);
        Element metamodel = this.document.createElement("XMI.metamodel");
        metamodel.setAttribute("xmi.name", "UML");
        metamodel.setAttribute("xmi.version", "1.3");
        header.appendChild(metamodel);
        Element content = this.document.createElement("XMI.content");
        xmi.appendChild(content);
        Element model = this.document.createElement("UML:Model");
        model.setAttribute("xmi.id", CucaDiagramXmiMaker.getModel(classDiagram));
        model.setAttribute("name", "PlantUML");
        content.appendChild(model);
        this.ownedElement = this.document.createElement("UML:Namespace.ownedElement");
        model.appendChild(this.ownedElement);
    }

    protected final String forXMI(String s2) {
        return s2.replace(':', ' ');
    }

    protected final String forXMI(Display s2) {
        if (Display.isNull(s2)) {
            return "";
        }
        return s2.get(0).toString().replace(':', ' ');
    }

    @Override
    public final void transformerXml(OutputStream os) throws TransformerException, ParserConfigurationException {
        DOMSource source = new DOMSource(this.document);
        StreamResult resultat = new StreamResult(os);
        TransformerFactory fabrique = TransformerFactory.newInstance();
        Transformer transformer = fabrique.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(source, resultat);
    }

    protected final Element createEntityNode(IEntity entity) {
        VisibilityModifier visibility;
        LeafType type;
        Element cla = this.document.createElement("UML:Class");
        if (entity.getLeafType() == LeafType.NOTE) {
            return null;
        }
        cla.setAttribute("xmi.id", entity.getUid());
        cla.setAttribute("name", entity.getDisplay().get(0).toString());
        String parentCode = entity.getIdent().parent().forXmi();
        if (parentCode.length() == 0) {
            cla.setAttribute("namespace", CucaDiagramXmiMaker.getModel(this.classDiagram));
        } else {
            cla.setAttribute("namespace", parentCode);
        }
        Stereotype stereotype = entity.getStereotype();
        if (stereotype != null) {
            Element stereo = this.document.createElement("UML:ModelElement.stereotype");
            for (String s2 : stereotype.getMultipleLabels()) {
                Element name = this.document.createElement("UML:Stereotype");
                name.setAttribute("name", s2);
                stereo.appendChild(name);
            }
            cla.appendChild(stereo);
        }
        if ((type = entity.getLeafType()) == LeafType.ABSTRACT_CLASS) {
            cla.setAttribute("isAbstract", "true");
        } else if (type == LeafType.INTERFACE) {
            cla.setAttribute("isInterface", "true");
        }
        Element feature = this.document.createElement("UML:Classifier.feature");
        cla.appendChild(feature);
        for (Member m3 : entity.getBodier().getFieldsToDisplay()) {
            Element attribute = this.document.createElement("UML:Attribute");
            attribute.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            attribute.setAttribute("name", m3.getDisplay(false));
            visibility = m3.getVisibilityModifier();
            if (visibility != null) {
                attribute.setAttribute("visibility", visibility.getXmiVisibility());
            }
            feature.appendChild(attribute);
        }
        for (Member m3 : entity.getBodier().getMethodsToDisplay()) {
            Element operation = this.document.createElement("UML:Operation");
            operation.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            operation.setAttribute("name", m3.getDisplay(false));
            visibility = m3.getVisibilityModifier();
            if (visibility != null) {
                operation.setAttribute("visibility", visibility.getXmiVisibility());
            }
            feature.appendChild(operation);
        }
        return cla;
    }
}

