/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.diagrams.DiagramsGlobalAssetsRegistration;
import org.testingisdocumenting.znai.diagrams.graphviz.Graphviz;
import org.testingisdocumenting.znai.diagrams.graphviz.GraphvizDiagram;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class GraphvizIncludePlugin
implements IncludePlugin {
    private Path diagramPath;

    @Override
    public String id() {
        return "graphviz";
    }

    @Override
    public IncludePlugin create() {
        return new GraphvizIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        String diagramId = this.generateId();
        this.diagramPath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        String gvContent = componentsRegistry.resourceResolver().textContent(this.diagramPath);
        DiagramsGlobalAssetsRegistration.register(componentsRegistry.globalAssetsRegistry());
        GraphvizDiagram diagram = Graphviz.graphvizEngine.diagramFromGv(pluginParams.getOpts().get("type", "dot"), diagramId, gvContent);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("diagram", diagram.toMap());
        props.put("urls", Collections.emptyList());
        return PluginResult.docElement("GraphVizDiagram", props);
    }

    private String generateId() {
        return "gv_" + UUID.randomUUID().toString().replaceAll("-", "_");
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.diagramPath));
    }
}

