/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.diagrams.DiagramsGlobalAssetsRegistration;
import org.testingisdocumenting.znai.diagrams.graphviz.Graphviz;
import org.testingisdocumenting.znai.diagrams.slides.DiagramSlides;
import org.testingisdocumenting.znai.diagrams.slides.MarkupDiagramSlides;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.NameUtils;

public class GvDiagramSlidesIncludePlugin
implements IncludePlugin {
    private List<AuxiliaryFile> auxiliaryFiles;
    private Path diagramPath;
    private Path slidesPath;

    @Override
    public String id() {
        return "gv-diagram-slides";
    }

    @Override
    public IncludePlugin create() {
        return new GvDiagramSlidesIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        MarkupParser parser = componentsRegistry.defaultParser();
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        DiagramsGlobalAssetsRegistration.register(componentsRegistry.globalAssetsRegistry());
        String diagramTitle = pluginParams.getFreeParam();
        String diagramId = NameUtils.idFromTitle(diagramTitle);
        this.diagramPath = resourcesResolver.fullPath(pluginParams.getOpts().getRequiredString("diagramPath"));
        this.slidesPath = resourcesResolver.fullPath(pluginParams.getOpts().getRequiredString("slidesPath"));
        String gvContent = resourcesResolver.textContent(this.diagramPath);
        String slidesContent = resourcesResolver.textContent(this.slidesPath);
        MarkupDiagramSlides markupSlides = new MarkupDiagramSlides(parser);
        DiagramSlides diagramSlides = markupSlides.create(markupPath, slidesContent);
        this.auxiliaryFiles = markupSlides.getAuxiliaryFiles();
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("slides", diagramSlides.toListOfMaps());
        props.put("diagram", Graphviz.graphvizEngine.diagramFromGv(pluginParams.getOpts().get("type", "dot"), diagramId, gvContent).toMap());
        return PluginResult.docElement("GraphVizFlow", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(this.auxiliaryFiles.stream(), Stream.of(AuxiliaryFile.builtTime(this.diagramPath), AuxiliaryFile.builtTime(this.slidesPath)));
    }
}

