/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.remove;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.enterprise.DocLifecycleListeners;
import org.testingisdocumenting.znai.enterprise.EnterpriseComponentsRegistry;
import org.testingisdocumenting.znai.enterprise.remove.OnRemoveFinishedServerHandler;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;
import znaishaded.org.apache.commons.io.FileUtils;

public class OnRemoveDeleteCachedServerHandler
implements OnRemoveFinishedServerHandler {
    @Override
    public void onRemoveFinished(ZnaiServerConfig config, String docId, String actor) {
        Path docPath = config.getDeployRoot().resolve(docId);
        ConsoleOutputs.out(new Object[]{Color.BLUE, "deleting docs: ", Color.PURPLE, docId, Color.BLACK, " at ", Color.PURPLE, docPath});
        File docDirectory = docPath.toFile();
        try {
            if (docDirectory.exists()) {
                FileUtils.deleteDirectory(docDirectory);
            }
            ConsoleOutputs.out(new Object[]{Color.BLUE, "deleted docs: ", Color.PURPLE, docPath, " from file system."});
            EnterpriseComponentsRegistry.documentationStorage().remove(actor, docId);
            DocLifecycleListeners.onDocRemove(docId);
            ConsoleOutputs.out(new Object[]{Color.BLUE, "deleted docs: ", Color.PURPLE, docPath, " from stroage."});
        }
        catch (IOException e) {
            ConsoleOutputs.out(new Object[]{Color.BLUE, "failed to delete docs: ", Color.PURPLE, docPath});
        }
    }
}

