/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedTextPart;

public class ApiLinkedText {
    private final List<ApiLinkedTextPart> parts = new ArrayList<ApiLinkedTextPart>();

    public ApiLinkedText() {
    }

    public ApiLinkedText(String textOnly) {
        if (!textOnly.trim().isEmpty()) {
            this.addPart(textOnly);
        }
    }

    public boolean contains(String text) {
        return this.parts.stream().anyMatch(p -> p.getText().contains(text));
    }

    public void addPart(String text) {
        this.parts.add(new ApiLinkedTextPart(text, ""));
    }

    public void addPart(String text, String refId) {
        this.parts.add(new ApiLinkedTextPart(text, refId));
    }

    public List<ApiLinkedTextPart> getParts() {
        return this.parts;
    }

    public List<Map<String, Object>> toListOfMaps() {
        return this.parts.stream().map(ApiLinkedTextPart::toMap).collect(Collectors.toList());
    }

    public String buildCombinedText() {
        return this.parts.stream().map(part -> part.getText().trim()).collect(Collectors.joining(" "));
    }
}

