/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.testingisdocumenting.webtau.Matchers;
import org.testingisdocumenting.webtau.WebTauCore;
import org.testingisdocumenting.znai.extensions.include.PluginsTestUtils;
import znaishaded.org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileIncludePluginTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public FileIncludePluginTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void should extract file snippet based on start line and number of lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[0].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', numberOfLines: 2}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', numberOfLines: 2}");
            text = string;
        }
        callSiteArray[1].call(text, callSiteArray[2].callStatic(WebTauCore.class, callSiteArray[3].call((Object)"a multiple lines\n", (Object)"line number")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[4].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', endLine: 'stop'}");
            text = string;
        }
        callSiteArray[5].call(text, callSiteArray[6].callStatic(WebTauCore.class, callSiteArray[7].call(callSiteArray[8].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should extract not match start line to the end line pattern but start from the one below() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[9].callStatic(FileIncludePluginTest.class, (Object)"file-with-similar-lines.txt", (Object)"{startLine: '$prompt >', endLine: '$prompt >'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-similar-lines.txt", "{startLine: '$prompt >', endLine: '$prompt >'}");
            text = string;
        }
        callSiteArray[10].call(text, callSiteArray[11].callStatic(WebTauCore.class, callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call((Object)"$prompt >\n", (Object)"some output\n"), (Object)"goes here\n"), (Object)"$prompt >")));
    }

    @Test
    public void should validate start and stop end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_start_and_stop_end_lines_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_start_and_stop_end_lines_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: '1multiple lines', endLine: 'stop'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_start_and_stop_end_lines_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_start_and_stop_end_lines_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_start_and_stop_end_lines_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[15].call(callSiteArray[16].callStatic(Matchers.class, (Object)new _should_validate_start_and_stop_end_lines_closure1(this, this)), callSiteArray[17].callStatic(Matchers.class, callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].call(callSiteArray[24].call((Object)"there is no line containing \"1multiple lines\" in <file.txt>:\n", (Object)"this is a\n"), (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
        public final class _should_validate_start_and_stop_end_lines_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_start_and_stop_end_lines_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: 'multiple lines', endLine: 'stop2'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_start_and_stop_end_lines_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_start_and_stop_end_lines_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_start_and_stop_end_lines_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[25].call(callSiteArray[26].callStatic(Matchers.class, (Object)new _should_validate_start_and_stop_end_lines_closure2(this, this)), callSiteArray[27].callStatic(Matchers.class, callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call((Object)"there is no line containing \"stop2\" in <file.txt>:\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines excluding them() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[33].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[34].call(text, callSiteArray[35].callStatic(WebTauCore.class, (Object)""));
    }

    @Test
    public void should extract file snippet based on surrounding pattern and exclude the pattern() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[36].callStatic(FileIncludePluginTest.class, (Object)"file-with-surround-marker.txt", (Object)"{surroundedBy: '# concept-example'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-surround-marker.txt", "{surroundedBy: '# concept-example'}");
            text = string;
        }
        callSiteArray[37].call(text, callSiteArray[38].callStatic(WebTauCore.class, callSiteArray[39].call((Object)"foo()\n", (Object)"bar()")));
    }

    @Test
    public void should extract file and exclude first and last line when excludeStartEnd is set and no start end is set() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[40].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[41].call(text, callSiteArray[42].callStatic(WebTauCore.class, callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call((Object)"test file in\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five")));
    }

    @Test
    public void should extract file snippet based on start line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[47].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines'}");
            text = string;
        }
        callSiteArray[48].call(text, callSiteArray[49].callStatic(WebTauCore.class, callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on start line and exclude only start() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[54].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'this is a', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'this is a', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[55].call(text, callSiteArray[56].callStatic(WebTauCore.class, callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].call((Object)"test file in\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on end line and exclude only end() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[62].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{endLine: '--- stop', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{endLine: '--- stop', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[63].call(text, callSiteArray[64].callStatic(WebTauCore.class, callSiteArray[65].call(callSiteArray[66].call(callSiteArray[67].call((Object)"this is a\n", (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number")));
    }

    @Test
    public void should extract file snippet based on end line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[68].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{endLine: 'stop'}");
            text = string;
        }
        callSiteArray[69].call(text, callSiteArray[70].callStatic(WebTauCore.class, callSiteArray[71].call(callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call((Object)"this is a\n", (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should automatically strip extra indentation() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[75].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{startLine: 'class', endLine: '}', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{startLine: 'class', endLine: '}', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[76].call(text, callSiteArray[77].callStatic(WebTauCore.class, callSiteArray[78].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should only include lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object singleImport = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            singleImport = object = callSiteArray[79].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import.*ClassName'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import.*ClassName'}");
            singleImport = string;
        }
        callSiteArray[80].call(singleImport, callSiteArray[81].callStatic(WebTauCore.class, (Object)"import a.b.c.ClassName"));
        Object allImports = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            allImports = object = callSiteArray[82].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import'}");
            allImports = string;
        }
        callSiteArray[83].call(allImports, callSiteArray[84].callStatic(WebTauCore.class, callSiteArray[85].call((Object)"import e.d.g.AnotherName\n", (Object)"import a.b.c.ClassName")));
    }

    @Test
    public void should only include lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[86].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: ['int', 'def']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: ['int', 'def']}");
            result = string;
        }
        callSiteArray[87].call(result, callSiteArray[88].callStatic(WebTauCore.class, callSiteArray[89].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should fail if none of the include regexps matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_include_regexps_matches_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_include_regexps_matches_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure3.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{includeRegexp: ['in2t', 'de2f']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_include_regexps_matches_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_include_regexps_matches_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[90].call(callSiteArray[91].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_include_regexps_matches_closure3(this, this)), callSiteArray[92].callStatic(Matchers.class, callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].call(callSiteArray[96].call(callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].call((Object)"there are no lines matching includeRegexp <in2t>, <de2f> in <script.groovy>:\n", (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should exclude lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[100].callStatic(FileIncludePluginTest.class, (Object)"sample-with-marker.py", (Object)"{excludeRegexp: '# exa..le'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-marker.py", "{excludeRegexp: '# exa..le'}");
            withoutMarkers = string;
        }
        callSiteArray[101].call(withoutMarkers, callSiteArray[102].callStatic(WebTauCore.class, (Object)"print(\"hello\")"));
    }

    @Test
    public void should exclude lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[103].callStatic(FileIncludePluginTest.class, (Object)"sample-with-multi-marker.py", (Object)"{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-multi-marker.py", "{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
            withoutMarkers = string;
        }
        callSiteArray[104].call(withoutMarkers, callSiteArray[105].callStatic(WebTauCore.class, callSiteArray[106].call(callSiteArray[107].call((Object)"print(\"hello\")\n", (Object)"\n"), (Object)"print(\"hello world\")")));
    }

    @Test
    public void should fail if none of the exclude regexp matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_exclude_regexp_matches_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_exclude_regexp_matches_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure4.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"sample-with-multi-marker.py", (Object)"{excludeRegexp: [\"# exam34ple\", \"# .roc3edur.\"]}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_exclude_regexp_matches_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_exclude_regexp_matches_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[108].call(callSiteArray[109].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_exclude_regexp_matches_closure4(this, this)), callSiteArray[110].callStatic(Matchers.class, callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].call(callSiteArray[115].call(callSiteArray[116].call(callSiteArray[117].call((Object)"there are no lines matching excludeRegexp <# exam34ple>, <# .roc3edur.> in <sample-with-multi-marker.py>:\n", (Object)"# example: how to print\n"), (Object)"print(\"hello\")\n"), (Object)"# example-end\n"), (Object)"\n"), (Object)"# procedure: how to print\n"), (Object)"print(\"hello world\")\n"), (Object)"# procedure-end")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a line idx() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[118].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 3}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 3}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure5.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlight: 7}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[119].call(callSiteArray[120].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure5(this, this)), callSiteArray[121].callStatic(Matchers.class, callSiteArray[122].call((Object)"highlight idx is out of range: 7\n", (Object)"check: script.groovy")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a text() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[123].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'def a'}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 'def a'}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure6.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlight: 'def c'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_text_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[124].call(callSiteArray[125].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure6(this, this)), callSiteArray[126].callStatic(Matchers.class, callSiteArray[127].call(callSiteArray[128].call(callSiteArray[129].call(callSiteArray[130].call(callSiteArray[131].call(callSiteArray[132].call(callSiteArray[133].call(callSiteArray[134].call((Object)"highlight text <def c> is not found\n", (Object)"check: script.groovy\n"), (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should highlight lines based on contains() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[135].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'class'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlight: 'class'}");
            props = map;
        }
        callSiteArray[136].call(callSiteArray[137].callGetProperty(props), callSiteArray[138].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{3})));
    }

    @Test
    public void should highlight lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[139].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlightPath: 'highlight.txt'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlightPath: 'highlight.txt'}");
            props = map;
        }
        callSiteArray[140].call(callSiteArray[141].callGetProperty(props), callSiteArray[142].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{4, 5})));
    }

    @Test
    public void when title is not set should auto generate title based file name() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[143].call(callSiteArray[144].callGetProperty(callSiteArray[145].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{autoTitle: true}")), callSiteArray[146].callStatic(WebTauCore.class, (Object)"script.groovy"));
            callSiteArray[147].call(callSiteArray[148].callGetProperty(callSiteArray[149].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{autoTitle: false}")), callSiteArray[150].callStatic(WebTauCore.class, null));
        } else {
            callSiteArray[151].call(callSiteArray[152].callGetProperty(FileIncludePluginTest.resultingProps("script.groovy", "{autoTitle: true}")), callSiteArray[153].callStatic(WebTauCore.class, (Object)"script.groovy"));
            callSiteArray[154].call(callSiteArray[155].callGetProperty(FileIncludePluginTest.resultingProps("script.groovy", "{autoTitle: false}")), callSiteArray[156].callStatic(WebTauCore.class, null));
        }
    }

    @Test
    public void should not allow autoTitle and title() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_not_allow_autoTitle_and_title_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_not_allow_autoTitle_and_title_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure7.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{title: 'hello', autoTitle: false}")), callSiteArray[3].callStatic(WebTauCore.class, null));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_not_allow_autoTitle_and_title_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "should";
                stringArray[1] = "title";
                stringArray[2] = "resultingProps";
                stringArray[3] = "equal";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _should_not_allow_autoTitle_and_title_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_should_not_allow_autoTitle_and_title_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_not_allow_autoTitle_and_title_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[157].call(callSiteArray[158].callStatic(Matchers.class, (Object)new _should_not_allow_autoTitle_and_title_closure7(this, this)), callSiteArray[159].callStatic(Matchers.class, (Object)"Can't have both <title> and <autoTitle> specified"));
    }

    @Test
    public void should validate lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_lines_from_a_highlight_text_file_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_lines_from_a_highlight_text_file_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure8.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlightPath: 'missing-highlight.txt'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_lines_from_a_highlight_text_file_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingProps";
                return new CallSiteArray(_should_validate_lines_from_a_highlight_text_file_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[160].call(callSiteArray[161].callStatic(Matchers.class, (Object)new _should_validate_lines_from_a_highlight_text_file_closure8(this, this)), callSiteArray[162].callStatic(Matchers.class, ScriptBytecodeAdapter.bitwiseNegate((Object)"highlight text <def g> is not found")));
    }

    private static String resultingSnippet(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[163].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})));
    }

    private static Map<String, Object> resultingProps(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})), Map.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileIncludePluginTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "resultingSnippet";
        stringArray[1] = "should";
        stringArray[2] = "equal";
        stringArray[3] = "plus";
        stringArray[4] = "resultingSnippet";
        stringArray[5] = "should";
        stringArray[6] = "equal";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "resultingSnippet";
        stringArray[10] = "should";
        stringArray[11] = "equal";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "should";
        stringArray[16] = "code";
        stringArray[17] = "throwException";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "plus";
        stringArray[21] = "plus";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "should";
        stringArray[26] = "code";
        stringArray[27] = "throwException";
        stringArray[28] = "plus";
        stringArray[29] = "plus";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "resultingSnippet";
        stringArray[34] = "should";
        stringArray[35] = "equal";
        stringArray[36] = "resultingSnippet";
        stringArray[37] = "should";
        stringArray[38] = "equal";
        stringArray[39] = "plus";
        stringArray[40] = "resultingSnippet";
        stringArray[41] = "should";
        stringArray[42] = "equal";
        stringArray[43] = "plus";
        stringArray[44] = "plus";
        stringArray[45] = "plus";
        stringArray[46] = "plus";
        stringArray[47] = "resultingSnippet";
        stringArray[48] = "should";
        stringArray[49] = "equal";
        stringArray[50] = "plus";
        stringArray[51] = "plus";
        stringArray[52] = "plus";
        stringArray[53] = "plus";
        stringArray[54] = "resultingSnippet";
        stringArray[55] = "should";
        stringArray[56] = "equal";
        stringArray[57] = "plus";
        stringArray[58] = "plus";
        stringArray[59] = "plus";
        stringArray[60] = "plus";
        stringArray[61] = "plus";
        stringArray[62] = "resultingSnippet";
        stringArray[63] = "should";
        stringArray[64] = "equal";
        stringArray[65] = "plus";
        stringArray[66] = "plus";
        stringArray[67] = "plus";
        stringArray[68] = "resultingSnippet";
        stringArray[69] = "should";
        stringArray[70] = "equal";
        stringArray[71] = "plus";
        stringArray[72] = "plus";
        stringArray[73] = "plus";
        stringArray[74] = "plus";
        stringArray[75] = "resultingSnippet";
        stringArray[76] = "should";
        stringArray[77] = "equal";
        stringArray[78] = "plus";
        stringArray[79] = "resultingSnippet";
        stringArray[80] = "should";
        stringArray[81] = "equal";
        stringArray[82] = "resultingSnippet";
        stringArray[83] = "should";
        stringArray[84] = "equal";
        stringArray[85] = "plus";
        stringArray[86] = "resultingSnippet";
        stringArray[87] = "should";
        stringArray[88] = "equal";
        stringArray[89] = "plus";
        stringArray[90] = "should";
        stringArray[91] = "code";
        stringArray[92] = "throwException";
        stringArray[93] = "plus";
        stringArray[94] = "plus";
        stringArray[95] = "plus";
        stringArray[96] = "plus";
        stringArray[97] = "plus";
        stringArray[98] = "plus";
        stringArray[99] = "plus";
        stringArray[100] = "resultingSnippet";
        stringArray[101] = "should";
        stringArray[102] = "equal";
        stringArray[103] = "resultingSnippet";
        stringArray[104] = "should";
        stringArray[105] = "equal";
        stringArray[106] = "plus";
        stringArray[107] = "plus";
        stringArray[108] = "should";
        stringArray[109] = "code";
        stringArray[110] = "throwException";
        stringArray[111] = "plus";
        stringArray[112] = "plus";
        stringArray[113] = "plus";
        stringArray[114] = "plus";
        stringArray[115] = "plus";
        stringArray[116] = "plus";
        stringArray[117] = "plus";
        stringArray[118] = "resultingSnippet";
        stringArray[119] = "should";
        stringArray[120] = "code";
        stringArray[121] = "throwException";
        stringArray[122] = "plus";
        stringArray[123] = "resultingSnippet";
        stringArray[124] = "should";
        stringArray[125] = "code";
        stringArray[126] = "throwException";
        stringArray[127] = "plus";
        stringArray[128] = "plus";
        stringArray[129] = "plus";
        stringArray[130] = "plus";
        stringArray[131] = "plus";
        stringArray[132] = "plus";
        stringArray[133] = "plus";
        stringArray[134] = "plus";
        stringArray[135] = "resultingProps";
        stringArray[136] = "should";
        stringArray[137] = "highlight";
        stringArray[138] = "equal";
        stringArray[139] = "resultingProps";
        stringArray[140] = "should";
        stringArray[141] = "highlight";
        stringArray[142] = "equal";
        stringArray[143] = "should";
        stringArray[144] = "title";
        stringArray[145] = "resultingProps";
        stringArray[146] = "equal";
        stringArray[147] = "should";
        stringArray[148] = "title";
        stringArray[149] = "resultingProps";
        stringArray[150] = "equal";
        stringArray[151] = "should";
        stringArray[152] = "title";
        stringArray[153] = "equal";
        stringArray[154] = "should";
        stringArray[155] = "title";
        stringArray[156] = "equal";
        stringArray[157] = "should";
        stringArray[158] = "code";
        stringArray[159] = "throwException";
        stringArray[160] = "should";
        stringArray[161] = "code";
        stringArray[162] = "throwException";
        stringArray[163] = "processAndGetSimplifiedCodeBlock";
        stringArray[164] = "processIncludeAndGetProps";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[165];
        FileIncludePluginTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FileIncludePluginTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileIncludePluginTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

