/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.json;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.json.JsonPaths;
import org.testingisdocumenting.znai.extensions.validation.EntryPresenceValidation;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.JsonUtils;
import znaishaded.com.jayway.jsonpath.JsonPath;
import znaishaded.com.jayway.jsonpath.Predicate;

public class JsonIncludePlugin
implements IncludePlugin {
    private String fileName;
    private ResourcesResolver resourcesResolver;
    private Path pathsFilePath;

    @Override
    public String id() {
        return "json";
    }

    @Override
    public IncludePlugin create() {
        return new JsonIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.resourcesResolver = componentsRegistry.resourceResolver();
        this.fileName = pluginParams.getFreeParam();
        String json = this.resourcesResolver.textContent(this.fileName);
        String jsonPath = pluginParams.getOpts().get("include", "$");
        Object content = JsonPath.read(json, jsonPath, new Predicate[0]);
        List<String> paths = this.extractPaths(pluginParams.getOpts());
        JsonIncludePlugin.validatePaths(content, paths);
        Map<String, Object> props = pluginParams.getOpts().toMap();
        props.put("data", content);
        props.put("paths", paths);
        return PluginResult.docElement("Json", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        Stream pathsFile = this.pathsFilePath == null ? Stream.empty() : Stream.of(AuxiliaryFile.builtTime(this.pathsFilePath));
        return Stream.concat(pathsFile, Stream.of(AuxiliaryFile.builtTime(componentsRegistry.resourceResolver().fullPath(this.fileName))));
    }

    private List<String> extractPaths(PluginParamsOpts opts) {
        if (opts.has("pathsFile")) {
            String filePath = (String)opts.get("pathsFile");
            this.pathsFilePath = this.resourcesResolver.fullPath(filePath);
            return JsonUtils.deserializeAsList(this.resourcesResolver.textContent(filePath));
        }
        return opts.getList("paths");
    }

    private static void validatePaths(Object json, List<String> paths) {
        Set<String> existingPaths = JsonIncludePlugin.buildPaths(json);
        EntryPresenceValidation.validateItemsPresence("path", "JSON", existingPaths, paths);
    }

    private static Set<String> buildPaths(Object json) {
        return new JsonPaths(json).getPaths();
    }
}

