/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.sstore;

import znaishaded.io.vertx.codegen.annotations.Fluent;
import znaishaded.io.vertx.codegen.annotations.Nullable;
import znaishaded.io.vertx.codegen.annotations.VertxGen;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.ServiceHelper;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.sstore.impl.ClusteredSessionStoreImpl;
import znaishaded.io.vertx.ext.web.sstore.impl.LocalSessionStoreImpl;

@VertxGen
public interface SessionStore {
    public static final int DEFAULT_SESSIONID_LENGTH = 16;

    public static SessionStore create(Vertx vertx) {
        return SessionStore.create(vertx, new JsonObject());
    }

    public static SessionStore create(Vertx vertx, JsonObject options) {
        SessionStore defaultStore;
        try {
            defaultStore = ServiceHelper.loadFactoryOrNull(SessionStore.class);
            if (defaultStore != null) {
                return defaultStore.init(vertx, options);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        defaultStore = vertx.isClustered() ? new ClusteredSessionStoreImpl() : new LocalSessionStoreImpl();
        return defaultStore.init(vertx, options);
    }

    @Fluent
    public SessionStore init(Vertx var1, JsonObject var2);

    public long retryTimeout();

    public Session createSession(long var1);

    public Session createSession(long var1, int var3);

    public void get(String var1, Handler<AsyncResult<@Nullable Session>> var2);

    public void delete(String var1, Handler<AsyncResult<Void>> var2);

    public void put(Session var1, Handler<AsyncResult<Void>> var2);

    public void clear(Handler<AsyncResult<Void>> var1);

    public void size(Handler<AsyncResult<Integer>> var1);

    public void close();
}

