/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.note.sequence;

import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import znaishaded.net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteStyle;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public final class FactorySequenceNoteOnArrowCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(FactorySequenceNoteOnArrowCommand.class.getName() + "multi", RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|bottom|top)"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(FactorySequenceNoteOnArrowCommand.class.getName() + "single", RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|bottom|top)"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.*)"), RegexLeaf.end());
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram system, LineLocation location, RegexResult arg) {
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(system, arg, BlocLines.getWithNewlines(arg.get("NOTE", 0)));
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^[%s]*end[%s]?note$";
            }

            @Override
            protected CommandExecutionResult executeNow(SequenceDiagram diagram, BlocLines lines) {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(diagram, line0, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram diagram, RegexResult line0, BlocLines lines) {
        EventWithDeactivate m3 = diagram.getLastEventWithDeactivate();
        if (m3 instanceof AbstractMessage || m3 instanceof GroupingLeaf) {
            NotePosition position = NotePosition.valueOf(StringUtils.goUpperCase(line0.get("POSITION", 0)));
            Url url = null;
            if (line0.get("URL", 0) != null) {
                UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                url = urlBuilder.getUrl(line0.get("URL", 0));
            }
            NoteStyle style = NoteStyle.getNoteStyle(line0.get("STYLE", 0));
            Display display = diagram.manageVariable(lines.toDisplay());
            String backcolor0 = line0.get("COLOR", 0);
            Colors colors = Colors.empty().add(ColorType.BACK, HColorSet.instance().getColorIfValid(backcolor0));
            Note note = new Note(display, position, style, diagram.getSkinParam().getCurrentStyleBuilder());
            String stereotypeString = line0.get("STEREO", 0);
            if (stereotypeString != null) {
                Stereotype stereotype = new Stereotype(stereotypeString);
                colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), FontParam.NOTE, ColorParam.noteBackground, ColorParam.noteBorder);
                note.setStereotype(stereotype);
            }
            note.setUrl(url);
            note.setColors(colors);
            if (m3 instanceof AbstractMessage) {
                ((AbstractMessage)m3).setNote(note);
            } else {
                ((GroupingLeaf)m3).setNote(note);
            }
        }
        return CommandExecutionResult.ok();
    }
}

