/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2Impl;

public final class UmlSource {
    private final List<StringLocated> source;
    private final List<StringLocated> rawSource;

    public UmlSource removeInitialSkinparam() {
        if (!UmlSource.hasInitialSkinparam(this.source)) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.source);
        while (UmlSource.hasInitialSkinparam(copy)) {
            copy.remove(1);
        }
        return new UmlSource(copy, this.rawSource);
    }

    public boolean containsIgnoreCase(String searched) {
        for (StringLocated s2 : this.source) {
            if (!StringUtils.goLowerCase(s2.getString()).contains(searched)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInitialSkinparam(List<StringLocated> copy) {
        return copy.size() > 1 && (copy.get(1).getString().startsWith("skinparam ") || copy.get(1).getString().startsWith("skinparamlocked "));
    }

    private UmlSource(List<StringLocated> source, List<StringLocated> rawSource) {
        this.source = source;
        this.rawSource = rawSource;
    }

    public UmlSource(List<StringLocated> data, boolean checkEndingBackslash) {
        this(data, checkEndingBackslash, new ArrayList<StringLocated>());
    }

    public UmlSource(List<StringLocated> data, boolean checkEndingBackslash, List<StringLocated> rawSource) {
        this(new ArrayList<StringLocated>(), rawSource);
        if (checkEndingBackslash) {
            StringBuilder pending = new StringBuilder();
            for (StringLocated cs : data) {
                String s2 = cs.getString();
                if (StringUtils.endsWithBackslash(s2)) {
                    pending.append(s2.substring(0, s2.length() - 1));
                    continue;
                }
                pending.append(s2);
                this.source.add(new StringLocated(pending.toString(), cs.getLocation()));
                pending.setLength(0);
            }
        } else {
            this.source.addAll(data);
        }
    }

    public DiagramType getDiagramType() {
        return DiagramType.getTypeFromArobaseStart(this.source.get(0).getString());
    }

    public IteratorCounter2 iterator2() {
        return new IteratorCounter2Impl(this.source);
    }

    public String getPlainString() {
        StringBuilder sb = new StringBuilder();
        for (StringLocated s2 : this.source) {
            sb.append(s2.getString());
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getRawString() {
        StringBuilder sb = new StringBuilder();
        for (StringLocated s2 : this.rawSource) {
            sb.append(s2.getString());
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public long seed() {
        long h2 = 1125899906842597L;
        String string = this.getPlainString();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h2 = 31L * h2 + (long)string.charAt(i);
        }
        return h2;
    }

    public String getLine(LineLocation n) {
        for (StringLocated s2 : this.source) {
            if (s2.getLocation().compareTo(n) != 0) continue;
            return s2.getString();
        }
        return null;
    }

    public int getTotalLineCount() {
        return this.source.size();
    }

    public boolean isEmpty() {
        for (StringLocated s2 : this.source) {
            if (StartUtils.isArobaseStartDiagram(s2.getString()) || StartUtils.isArobaseEndDiagram(s2.getString()) || s2.getString().matches("\\s*'.*") || StringUtils.trin(s2.getString()).length() == 0) continue;
            return false;
        }
        return true;
    }

    public Display getTitle() {
        Pattern2 p = MyPattern.cmpile("(?i)^[%s]*title[%s]+(.+)$");
        for (StringLocated s2 : this.source) {
            Matcher2 m3 = p.matcher(s2.getString());
            boolean ok = m3.matches();
            if (!ok) continue;
            return Display.create(m3.group(1));
        }
        return Display.empty();
    }

    public boolean isStartDef() {
        return this.source.get(0).getString().startsWith("@startdef");
    }

    public String getId() {
        Pattern p = Pattern.compile("id=([\\w]+)\\b");
        Matcher m3 = p.matcher(this.source.get(0).getString());
        if (m3.find()) {
            return m3.group(1);
        }
        return null;
    }
}

