/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.rosetta;

import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.BackSlash;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.atom.AbstractAtom;
import znaishaded.net.sourceforge.plantuml.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorAutomatic;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import znaishaded.net.sourceforge.plantuml.utils.CharHidder;

public class AtomText22
extends AbstractAtom
implements Atom {
    private static DelayedDouble ZERO = new DelayedDouble(){

        @Override
        public double getDouble(StringBounder stringBounder) {
            return 0.0;
        }
    };
    private final FontConfiguration fontConfiguration;
    private final String text;
    private final DelayedDouble marginLeft;
    private final DelayedDouble marginRight;
    private final Url url;

    public static Atom create(String text, FontConfiguration fontConfiguration) {
        return new AtomText22(text, fontConfiguration, null, ZERO, ZERO);
    }

    public String toString() {
        return this.text + " " + this.fontConfiguration;
    }

    private AtomText22(String text, FontConfiguration style, Url url, DelayedDouble marginLeft, DelayedDouble marginRight) {
        if (text.contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(text);
        }
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.text = CharHidder.unhide(text);
        this.fontConfiguration = style;
        this.url = url;
    }

    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D rect = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        Log.debug("g2d=" + rect);
        Log.debug("Size for " + this.text + " is " + rect);
        double h2 = rect.getHeight();
        if (h2 < 10.0) {
            h2 = 10.0;
        }
        double width = this.text.indexOf(9) == -1 ? rect.getWidth() : this.getWidth(stringBounder);
        double left = this.marginLeft.getDouble(stringBounder);
        double right = this.marginRight.getDouble(stringBounder);
        return new Dimension2DDouble(width + left + right, h2);
    }

    private double getDescent() {
        LineMetrics fm = TextBlockUtils.getLineMetrics(this.fontConfiguration.getFont(), this.text);
        double descent = fm.getDescent();
        return descent;
    }

    public double getFontSize2D() {
        return this.fontConfiguration.getFont().getSize2D();
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return this.fontConfiguration.getSpace();
    }

    private double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.tabString()).getWidth();
    }

    private String tabString() {
        int nb = this.fontConfiguration.getTabSize();
        if (nb >= 1 && nb < 7) {
            return "        ".substring(0, nb);
        }
        return "        ";
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (ug.matchesProperty("SPECIALTXT")) {
            ug.draw(this);
            throw new UnsupportedOperationException("SPECIALTXT");
        }
        HColor textColor = this.fontConfiguration.getColor();
        FontConfiguration useFontConfiguration = this.fontConfiguration;
        if (textColor instanceof HColorAutomatic && ug.getParam().getBackcolor() != null) {
            textColor = ((HColorSimple)ug.getParam().getBackcolor()).opposite();
            useFontConfiguration = this.fontConfiguration.changeColor(textColor);
        }
        if (this.marginLeft != ZERO) {
            ug = ug.apply(UTranslate.dx(this.marginLeft.getDouble(ug.getStringBounder())));
        }
        StringTokenizer tokenizer = new StringTokenizer(this.text, "\t", true);
        double x = 0.0;
        Dimension2D rect = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), this.text);
        double descent = this.getDescent();
        double ypos = rect.getHeight() - descent;
        if (tokenizer.hasMoreTokens()) {
            double tabSize = this.getTabSize(ug.getStringBounder());
            while (tokenizer.hasMoreTokens()) {
                String s2 = tokenizer.nextToken();
                if (s2.equals("\t")) {
                    double remainder = x % tabSize;
                    x += tabSize - remainder;
                    continue;
                }
                UText utext = new UText(s2, useFontConfiguration);
                Dimension2D dim = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), s2);
                ug.apply(new UTranslate(x, ypos)).draw(utext);
                x += dim.getWidth();
            }
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private double getWidth(StringBounder stringBounder) {
        return this.getWidth(stringBounder, this.text);
    }

    private double getWidth(StringBounder stringBounder, String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\t", true);
        double tabSize = this.getTabSize(stringBounder);
        double x = 0.0;
        while (tokenizer.hasMoreTokens()) {
            String s2 = tokenizer.nextToken();
            if (s2.equals("\t")) {
                double remainder = x % tabSize;
                x += tabSize - remainder;
                continue;
            }
            Dimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s2);
            x += dim.getWidth();
        }
        return x;
    }

    public List<AtomText22> getSplitted(StringBounder stringBounder, LineBreakStrategy maxWidthAsString) {
        double maxWidth = maxWidthAsString.getMaxWidth();
        if (maxWidth == 0.0) {
            throw new IllegalStateException();
        }
        ArrayList<AtomText22> result = new ArrayList<AtomText22>();
        StringTokenizer st = new StringTokenizer(this.text, " ", true);
        StringBuilder currentLine = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token1 = st.nextToken();
            for (String tmp : Arrays.asList(token1)) {
                double w = this.getWidth(stringBounder, currentLine + tmp);
                if (w > maxWidth) {
                    result.add(new AtomText22(currentLine.toString(), this.fontConfiguration, this.url, this.marginLeft, this.marginRight));
                    currentLine.setLength(0);
                    if (tmp.startsWith(" ")) continue;
                    currentLine.append(tmp);
                    continue;
                }
                currentLine.append(tmp);
            }
        }
        result.add(new AtomText22(currentLine.toString(), this.fontConfiguration, this.url, this.marginLeft, this.marginRight));
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Atom> splitInTwo(StringBounder stringBounder, double width) {
        StringBuilder tmp = new StringBuilder();
        for (String token : this.splitted()) {
            if (tmp.length() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.getWidth(stringBounder, stringBuilder.append(tmp.toString()).append(token).toString()) > width) {
                    AtomText22 part1 = new AtomText22(tmp.toString(), this.fontConfiguration, this.url, this.marginLeft, this.marginRight);
                    String remain = this.text.substring(tmp.length());
                    while (remain.startsWith(" ")) {
                        remain = remain.substring(1);
                    }
                    AtomText22 part2 = new AtomText22(remain, this.fontConfiguration, this.url, this.marginLeft, this.marginRight);
                    return Arrays.asList(part1, part2);
                }
            }
            tmp.append(token);
        }
        return Collections.singletonList(this);
    }

    private Collection<String> splitted() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (Character.isLetter(ch)) {
                StringBuilder tmp = new StringBuilder();
                tmp.append(ch);
                while (i + 1 < this.text.length() && Character.isLetter(this.text.charAt(i + 1))) {
                    tmp.append(this.text.charAt(++i));
                }
                result.add(tmp.toString());
                continue;
            }
            result.add("" + this.text.charAt(i));
        }
        return result;
    }

    public final String getText() {
        return this.text;
    }

    static interface DelayedDouble {
        public double getDouble(StringBounder var1);
    }
}

