/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import znaishaded.net.sourceforge.plantuml.svek.Ports;

public class EntityPort {
    private final String entityUid;
    private final String portId;

    public EntityPort(String entityUid, String portName) {
        this.entityUid = entityUid;
        this.portId = portName == null ? null : Ports.encodePortNameToId(portName);
    }

    public String getFullString() {
        if (this.portId != null) {
            return this.entityUid + ":" + this.portId;
        }
        return this.entityUid;
    }

    private boolean isShielded() {
        return this.entityUid.endsWith(":h");
    }

    public String getPrefix() {
        if (this.isShielded()) {
            return this.entityUid.substring(0, this.entityUid.length() - 2);
        }
        return this.entityUid;
    }

    public boolean startsWith(String centerId) {
        return this.entityUid.startsWith(centerId);
    }

    public boolean equalsId(EntityPort other) {
        return this.entityUid.equals(other.entityUid);
    }
}

