/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.Locale;
import znaishaded.net.sourceforge.plantuml.geom.AbstractLineSegment;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class LineSegmentDouble
extends AbstractLineSegment {
    private final Point2D p1;
    private final Point2D p2;

    public String toString() {
        return String.format(Locale.US, "( %.2f,%.2f - %.2f,%.2f )", this.getP1().getX(), this.getP1().getY(), this.getP2().getX(), this.getP2().getY());
    }

    public LineSegmentDouble(double x1, double y1, double x2, double y2) {
        this(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
    }

    public LineSegmentDouble(Point2D p1, Point2D p2) {
        this.p1 = p1;
        this.p2 = p2;
        if (p1.equals(p2)) {
            throw new IllegalArgumentException();
        }
        assert (p1 != null && p2 != null);
        assert (this.getLength() > 0.0);
        assert (this.getDistance(this) == 0.0);
    }

    public LineSegmentDouble(CubicCurve2D.Double curve) {
        this(curve.getP1(), curve.getP2());
    }

    public LineSegmentDouble translate(UTranslate translate) {
        return new LineSegmentDouble(translate.getTranslated(this.getP1()), translate.getTranslated(this.getP2()));
    }

    @Override
    public Point2D getP1() {
        return this.p1;
    }

    @Override
    public Point2D getP2() {
        return this.p2;
    }

    @Override
    public double getX1() {
        return this.p1.getX();
    }

    @Override
    public double getX2() {
        return this.p2.getX();
    }

    @Override
    public double getY1() {
        return this.p1.getY();
    }

    @Override
    public double getY2() {
        return this.p2.getY();
    }

    public void draw(UGraphic ug) {
        double x1 = this.p1.getX();
        double y1 = this.p1.getY();
        double x2 = this.p2.getX();
        double y2 = this.p2.getY();
        ug = ug.apply(new UTranslate(x1, y1));
        ug.draw(new ULine(x2 - x1, y2 - y1));
    }
}

