/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import znaishaded.net.sourceforge.plantuml.geom.Orientation;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;

public class Neighborhood {
    private final double angle1;
    private final double angle2;
    private final Point2DInt center;

    public Neighborhood(Point2DInt center) {
        this(center, 0.0, 0.0);
    }

    public boolean is360() {
        return this.angle1 == this.angle2;
    }

    public Neighborhood(Point2DInt center, double angle1, double angle2) {
        this.center = center;
        this.angle1 = angle1;
        this.angle2 = angle2;
    }

    public String toString() {
        int a1 = (int)(this.angle1 * 180.0 / Math.PI);
        int a2 = (int)(this.angle2 * 180.0 / Math.PI);
        return this.center + " " + a1 + " " + a2;
    }

    public final Point2DInt getCenter() {
        return this.center;
    }

    public final double getMiddle() {
        if (this.is360()) {
            return this.angle1 + Math.PI;
        }
        double result = (this.angle1 + this.angle2) / 2.0;
        if (this.angle2 < this.angle1) {
            result += Math.PI;
        }
        return result;
    }

    public boolean isInAngleStrict(double angle) {
        if (angle < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.angle2 > this.angle1) {
            return angle > this.angle1 && angle < this.angle2;
        }
        return angle > this.angle1 || angle < this.angle2;
    }

    public boolean isInAngleLarge(double angle) {
        if (angle < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.angle2 > this.angle1) {
            return angle >= this.angle1 && angle <= this.angle2;
        }
        return angle >= this.angle1 || angle <= this.angle2;
    }

    public boolean isAngleLimit(double angle) {
        return angle == this.angle1 || angle == this.angle2;
    }

    public Orientation getOrientationFrom(double angle) {
        if (this.angle1 == this.angle2) {
            throw new IllegalStateException();
        }
        if (angle != this.angle1 && angle != this.angle2) {
            throw new IllegalArgumentException("this=" + this + " angle=" + (int)(angle * 180.0 / Math.PI));
        }
        assert (angle == this.angle1 || angle == this.angle2);
        if (angle == this.angle1) {
            return Orientation.MATH;
        }
        return Orientation.CLOCK;
    }
}

