/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Neighborhood;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;

public class Singularity {
    private final TreeSet<Double> angles = new TreeSet();
    private final Point2DInt center;

    public Singularity(Point2DInt center) {
        this.center = center;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.center.toString());
        for (Double a : this.angles) {
            int degree = (int)(a * 180.0 / Math.PI);
            sb.append(' ');
            sb.append(degree);
        }
        return sb.toString();
    }

    public void addLineSegment(LineSegmentInt seg) {
        if (seg.getP1().equals(this.center)) {
            this.angles.add(Singularity.convertAngle(seg.getAngle()));
        } else if (seg.getP2().equals(this.center)) {
            this.angles.add(Singularity.convertAngle(seg.getOppositeAngle()));
        } else {
            assert (seg.side(this.center) == 0.0) : "side=" + seg.side(this.center) + " center=" + this.center + " seg=" + seg;
            assert (LineSegmentInt.isBetween(this.center, seg.getP1(), seg.getP2()));
            this.addLineSegment(new LineSegmentInt(this.center, seg.getP1()));
            this.addLineSegment(new LineSegmentInt(this.center, seg.getP2()));
        }
        assert (this.betweenZeroAndTwoPi());
    }

    static double convertAngle(double a) {
        if (a < 0.0) {
            return a + Math.PI * 2;
        }
        return a;
    }

    private boolean betweenZeroAndTwoPi() {
        for (Double d : this.angles) {
            assert (d >= 0.0);
            assert (d < Math.PI * 2);
        }
        return true;
    }

    List<Double> getAngles() {
        return new ArrayList<Double>(this.angles);
    }

    public boolean crossing(Point2DInt direction1, Point2DInt direction2) {
        boolean result = this.crossingInternal(direction1, direction2);
        assert (result == this.crossingInternal(direction2, direction1));
        return result;
    }

    private boolean crossingInternal(Point2DInt direction1, Point2DInt direction2) {
        if (this.angles.size() < 2) {
            return false;
        }
        double angle1 = Singularity.convertAngle(new LineSegmentInt(this.center, direction1).getAngle());
        double angle2 = Singularity.convertAngle(new LineSegmentInt(this.center, direction2).getAngle());
        Double last = null;
        for (Double current : this.angles) {
            if (last != null) {
                assert (last < current);
                if (this.isBetween(angle1, last, current) && this.isBetween(angle2, last, current)) {
                    return false;
                }
            }
            last = current;
        }
        double first = this.angles.first();
        return !(angle1 <= first) && !(angle1 >= last) || !(angle2 <= first) && !(angle2 >= last);
    }

    private boolean isBetween(double test2, double v1, double v2) {
        assert (v1 < v2);
        return test2 >= v1 && test2 <= v2;
    }

    protected final Point2DInt getCenter() {
        return this.center;
    }

    public void merge(Singularity other) {
        this.angles.addAll(other.angles);
    }

    public List<Neighborhood> getNeighborhoods() {
        if (this.angles.size() == 0) {
            return Collections.singletonList(new Neighborhood(this.center));
        }
        ArrayList<Neighborhood> result = new ArrayList<Neighborhood>();
        double last = this.angles.last();
        for (Double currentAngle : this.angles) {
            result.add(new Neighborhood(this.center, last, currentAngle));
            last = currentAngle;
        }
        return Collections.unmodifiableList(result);
    }
}

