/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.util.Random;
import znaishaded.net.sourceforge.plantuml.graph.Board;
import znaishaded.net.sourceforge.plantuml.graph.CostComputer;
import znaishaded.net.sourceforge.plantuml.graph.Move;

public class Oven {
    private final double temp;
    private final CostComputer costComputer;

    public Oven(double temp, CostComputer costComputer) {
        this.temp = temp;
        this.costComputer = costComputer;
    }

    public Board longTic(int nbTic, Board board, Random rnd) {
        double best = this.costComputer.getCost(board);
        Board bestBoard = board.copy();
        for (int i = 0; i < nbTic; ++i) {
            double current = this.tic(board, rnd);
            if (!(current < best)) continue;
            best = current;
            bestBoard = board.copy();
        }
        return bestBoard;
    }

    public double tic(Board board, Random rnd) {
        double costBefore = this.costComputer.getCost(board);
        Move move = null;
        board.applyMove(move);
        double costAfter = this.costComputer.getCost(board);
        double delta = costAfter - costBefore;
        if (delta <= 0.0) {
            return costAfter;
        }
        assert (delta > 0.0);
        assert (costAfter > costBefore);
        if (this.temp > 0.0) {
            double probability = Math.exp(-delta / this.temp);
            double dice = rnd.nextDouble();
            if (dice < probability) {
                return costAfter;
            }
        }
        board.applyMove(move.getBackMove());
        assert (costBefore == this.costComputer.getCost(board));
        return costBefore;
    }
}

