/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTileSelf
extends AbstractTile
implements TileWithUpdateStairs {
    private final LivingSpace livingSpace1;
    private final Message message;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final LivingSpaces livingSpaces;

    @Override
    public Event getEvent() {
        return this.message;
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getYPoint(stringBounder);
    }

    public CommunicationTileSelf(LivingSpace livingSpace1, Message message, Rose skin, ISkinParam skinParam, LivingSpaces livingSpaces) {
        this.livingSpace1 = livingSpace1;
        this.livingSpaces = livingSpaces;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    private ArrowComponent getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        arrowConfiguration = arrowConfiguration.self();
        ArrowComponent comp = this.skin.createComponentArrow(this.message.getUsedStyles(), arrowConfiguration, this.skinParam, this.message.getLabelNumbered());
        return comp;
    }

    @Override
    public void updateStairs(StringBounder stringBounder, double y) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        Point2D p1 = comp.getStartPoint(stringBounder, dim);
        Point2D p2 = comp.getEndPoint(stringBounder, dim);
        if (this.message.isActivate()) {
            this.livingSpace1.addStepForLivebox(this.getEvent(), y + p2.getY());
            Log.info("CommunicationTileSelf::updateStairs activate y=" + (y + p2.getY()) + " " + this.message);
        } else if (this.message.isDeactivate()) {
            this.livingSpace1.addStepForLivebox(this.getEvent(), y + p1.getY());
            Log.info("CommunicationTileSelf::updateStairs deactivate y=" + (y + p1.getY()) + " " + this.message);
        }
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double x1 = this.getPoint1(stringBounder).getCurrentValue();
        int levelIgnore = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_ACTIVATE);
        int levelConsidere = this.livingSpace1.getLevelAt(this, EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE);
        Log.info("CommunicationTileSelf::drawU levelIgnore=" + levelIgnore + " levelConsidere=" + levelConsidere);
        x1 += 5.0 * (double)levelIgnore;
        if (levelIgnore < levelConsidere) {
            x1 += 5.0;
        }
        Area area = new Area(dim.getWidth(), dim.getHeight());
        area.setDeltaX1((double)(levelIgnore - levelConsidere) * 5.0);
        ug = ug.apply(UTranslate.dx(x1));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim.getHeight();
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        LivingSpace next = this.getNext();
        if (next != null) {
            next.getPosC(stringBounder).ensureBiggerThan(this.getMaxX(stringBounder));
        }
    }

    private LivingSpace getNext() {
        Iterator<LivingSpace> it = this.livingSpaces.values().iterator();
        while (it.hasNext()) {
            LivingSpace current = it.next();
            if (current != this.livingSpace1 || !it.hasNext()) continue;
            return it.next();
        }
        return null;
    }

    private Real getPoint1(StringBounder stringBounder) {
        return this.livingSpace1.getPosC(stringBounder);
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.getPoint1(stringBounder);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double width = dim.getWidth();
        return this.livingSpace1.getPosC2(stringBounder).addFixed(width);
    }
}

