/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.io.PrintStream;
import java.util.Date;
import znaishaded.net.sourceforge.plantuml.stats.StatsUtils;
import znaishaded.net.sourceforge.plantuml.stats.TextTable;
import znaishaded.net.sourceforge.plantuml.stats.api.Stats;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsColumn;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsLine;

public class TextConverter {
    private final Stats stats;
    private int linesUsed;

    public TextConverter(Stats stats) {
        this.stats = stats;
    }

    public void printMe(PrintStream ps) {
        TextTable table = new TextTable();
        table.addSeparator();
        table.addLine("ID", "Start", "Duration", "Generated", "Mean(ms)");
        table.addSeparator();
        for (StatsLine line : this.stats.getLastSessions().getLines()) {
            Object id = (Long)line.getValue(StatsColumn.SESSION_ID);
            if (id == null) {
                id = "";
            }
            Date start = (Date)line.getValue(StatsColumn.STARTING);
            String duration = line.getValue(StatsColumn.DURATION_STRING).toString();
            Long generated = (Long)line.getValue(StatsColumn.GENERATED_COUNT);
            Long generated_ms = (Long)line.getValue(StatsColumn.GENERATED_MEAN_TIME);
            table.addLine(id, start, duration, generated, generated_ms);
        }
        table.addSeparator();
        this.linesUsed = table.getLines();
        table.printMe(ps);
    }

    public int getLinesUsed() {
        return this.linesUsed;
    }

    public static void main(String[] args) {
        StatsUtils.dumpStats();
    }
}

