/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.svek.extremity.Extremity;
import znaishaded.net.sourceforge.plantuml.ugraphic.UBackground;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

abstract class ExtremityExtendsLike
extends Extremity {
    private static final double XLEN = -19.0;
    private static final double HALF_WIDTH = 7.0;
    private final UPolygon trig;
    private final UBackground back;
    private final Point2D contact;

    @Override
    public Point2D somePoint() {
        return this.contact;
    }

    private static void addTrigPoint(UPolygon up, double x, double y, double angle, Point2D porig) {
        Point p = new Point(x, y);
        p.rotate(angle);
        p.translate(porig);
        p.add(up);
    }

    private ExtremityExtendsLike(Point2D porig, double angle, HColor backgroundColor) {
        this.back = backgroundColor.bg();
        this.contact = new Point2D.Double(porig.getX(), porig.getY());
        angle = this.manageround(angle);
        this.trig = new UPolygon();
        this.trig.addPoint(porig);
        ExtremityExtendsLike.addTrigPoint(this.trig, -19.0, -7.0, angle, porig);
        ExtremityExtendsLike.addTrigPoint(this.trig, -19.0, 7.0, angle, porig);
        this.trig.addPoint(porig);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(this.back).draw(this.trig);
    }

    static class DefinedBy
    extends ExtremityExtendsLike {
        private static final double XSUFFIX = -24.7;
        private static final double DOTHSIZE = 2.0;
        private final UTranslate pos1;
        private final UTranslate pos2;
        private final UEllipse dot;

        private static UTranslate getDotPos(double x, double y, double angle, double size, Point2D porig) {
            Point p = new Point(x, y);
            p.rotate(angle);
            p.x -= size;
            p.y -= size;
            return p.getPos(porig);
        }

        public DefinedBy(Point2D porig, double angle, HColor backgroundColor) {
            super(porig, angle, backgroundColor);
            double w = 5.0;
            this.pos1 = DefinedBy.getDotPos(-24.7, -w, angle, 2.0, porig);
            this.pos2 = DefinedBy.getDotPos(-24.7, w, angle, 2.0, porig);
            double s2 = 4.0;
            this.dot = new UEllipse(s2, s2);
        }

        @Override
        public void drawU(UGraphic ug) {
            super.drawU(ug);
            if (ug.getParam().getColor() != null) {
                ug = ug.apply(ug.getParam().getColor().bg());
            }
            ug.apply(this.pos1).draw(this.dot);
            ug.apply(this.pos2).draw(this.dot);
        }
    }

    static class Redefines
    extends ExtremityExtendsLike {
        private static final double XSUFFIX = -22.8;
        private final UStroke barStroke = new UStroke(2.0);
        private final UTranslate pos;
        private final ULine bar;

        public Redefines(Point2D porig, double angle, HColor backgroundColor) {
            super(porig, angle, backgroundColor);
            Point p1 = new Point(-22.8, -7.0);
            Point p2 = new Point(-22.8, 7.0);
            p1.rotate(angle);
            p2.rotate(angle);
            this.bar = new ULine(p2.x - p1.x, p2.y - p1.y);
            this.pos = p1.getPos(porig);
        }

        @Override
        public void drawU(UGraphic ug) {
            super.drawU(ug);
            ug.apply(this.barStroke).apply(this.pos).draw(this.bar);
        }
    }

    private static class Point {
        public double x;
        public double y;

        public void rotate(double theta) {
            double ct = Math.cos(theta);
            double st = -Math.sin(theta);
            double nx = this.x * ct - this.y * st;
            this.y = -this.x * st - this.y * ct;
            this.x = nx;
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public UTranslate getPos(Point2D pt) {
            return new UTranslate(this.x + pt.getX(), this.y + pt.getY());
        }

        public void translate(Point2D pt) {
            this.x += pt.getX();
            this.y += pt.getY();
        }

        public void add(UPolygon p) {
            p.addPoint(this.x, this.y);
        }
    }
}

