/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.svek.extremity.Extremity;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

class ExtremityPlus
extends Extremity {
    private final UEllipse circle;
    private final double px;
    private final double py;
    private static final double radius = 8.0;
    private final double angle;

    private ExtremityPlus(double x, double y, double angle) {
        this.angle = angle;
        this.circle = new UEllipse(16.0, 16.0);
        this.px = x;
        this.py = y;
    }

    @Override
    public Point2D somePoint() {
        return new Point2D.Double(this.px, this.py);
    }

    public static UDrawable create(Point2D p1, double angle) {
        double x = p1.getX() - 8.0 + 8.0 * Math.sin(angle);
        double y = p1.getY() - 8.0 - 8.0 * Math.cos(angle);
        return new ExtremityPlus(x, y, angle);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(HColorUtils.WHITE.bg()).apply(new UTranslate(this.px + 0.0, this.py + 0.0)).draw(this.circle);
        ExtremityPlus.drawLine(ug, 0.0, 0.0, this.getPointOnCircle(this.angle - 1.5707963267948966), this.getPointOnCircle(this.angle + 1.5707963267948966));
        ExtremityPlus.drawLine(ug, 0.0, 0.0, this.getPointOnCircle(this.angle), this.getPointOnCircle(this.angle + Math.PI));
    }

    private Point2D getPointOnCircle(double angle) {
        double x = this.px + 8.0 + 8.0 * Math.cos(angle);
        double y = this.py + 8.0 + 8.0 * Math.sin(angle);
        return new Point2D.Double(x, y);
    }

    private static void drawLine(UGraphic ug, double x, double y, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

