/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageBranch
extends AbstractEntityImage {
    private static final int SIZE = 12;

    public EntityImageBranch(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
    }

    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(24.0, 24.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UPolygon diams = new UPolygon();
        double shadowing = 0.0;
        diams.addPoint(12.0, 0.0);
        diams.addPoint(24.0, 12.0);
        diams.addPoint(12.0, 24.0);
        diams.addPoint(0.0, 12.0);
        diams.addPoint(12.0, 0.0);
        HColor border = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.activityDiamondBorder, ColorParam.activityBorder);
        HColor back = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.activityDiamondBackground, ColorParam.activityBackground);
        UStroke stroke = new UStroke(1.5);
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            border = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
            back = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
            stroke = style.getStroke();
            shadowing = style.value(PName.Shadowing).asDouble();
        } else if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            shadowing = 5.0;
        }
        diams.setDeltaShadow(shadowing);
        ug.apply(border).apply(back.bg()).apply(stroke).draw(diams);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.DIAMOND;
    }
}

