/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Guillemet;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageLollipopInterfaceEye2
extends AbstractEntityImage {
    public static final double SIZE = 14.0;
    private final TextBlock desc;
    private final TextBlock stereo;
    private final SymbolContext ctx;
    private final Url url;

    public EntityImageLollipopInterfaceEye2(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        USymbol symbol;
        Stereotype stereotype = entity.getStereotype();
        USymbol uSymbol = symbol = entity.getUSymbol() == null ? skinParam.componentStyle().toUSymbol() : entity.getUSymbol();
        if (symbol == null) {
            throw new IllegalArgumentException();
        }
        this.desc = new BodyEnhanced(entity.getDisplay(), symbol.getFontParam(), skinParam, HorizontalAlignment.CENTER, stereotype, symbol.manageHorizontalLine(), false, entity, SName.componentDiagram);
        this.url = entity.getUrl99();
        HColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), symbol.getColorParamBack());
        }
        HColor forecolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), symbol.getColorParamBorder());
        this.ctx = new SymbolContext(backcolor, forecolor).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing(this.getEntity().getStereotype()) ? 3.0 : 0.0);
        this.stereo = stereotype != null && stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(new FontConfiguration(this.getSkinParam(), symbol.getFontParamStereotype(), stereotype), HorizontalAlignment.CENTER, skinParam) : TextBlockUtils.empty(0.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(14.0, 14.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UEllipse circle = new UEllipse(14.0, 14.0);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            circle.setDeltaShadow(4.0);
        }
        this.ctx.apply(ug).draw(circle);
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x1 = 7.0 - dimDesc.getWidth() / 2.0;
        double y1 = 19.599999999999998;
        this.desc.drawU(ug.apply(new UTranslate(x1, 19.599999999999998)));
        Dimension2D dimStereo = this.stereo.calculateDimension(ug.getStringBounder());
        double x2 = 7.0 - dimStereo.getWidth() / 2.0;
        double y2 = -dimStereo.getHeight();
        this.stereo.drawU(ug.apply(new UTranslate(x2, y2)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

