/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.stdlib;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TFunctionSignature;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class DateFunction
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%date", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 0 || nbArg == 1;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values, Map<String, TValue> named) throws EaterException, EaterExceptionLocated {
        if (values.size() == 0) {
            return TValue.fromString(new Date().toString());
        }
        String format = values.get(0).toString();
        try {
            return TValue.fromString(new SimpleDateFormat(format).format(new Date()));
        }
        catch (Exception e) {
            throw EaterException.unlocated("Bad date pattern");
        }
    }
}

